1

                                                    May 16, 2008
                           Program DENDIF

              This program will draw a contour plot of the total
          electron density of a molecule.  It also will plot a
          density difference map.  The density difference map might
          be a whole molecule's density, minus the density of the
          individual atoms.  Note that the fragments could be
          molecular subunits larger than atoms.

              The necessary information to run this program is a set
          of molecular orbital grids of the natural orbitals of the
          whole molecule, produced by program PLTORB.  If a density
          difference map is desired, sets of orbital amplitude grids
          must be provided for each fragment's natural orbitals.

              If PLTORB was asked to produce orbital gradients, by
          any of its four keywords, this program will instead plot
          the Kinetic Energy Integrand,
   Sum on i  N-i*1/2*[(d(MO-i)/dx)**2 + (d(MO-i)/dy)**2 + (d(MO-i)/dz)**2]
          if only one set of plots is provided.  Optionally, the
          data for subunits may be subtracted to plot the "kinetic
          energy interference density".

              Limitations: the orbitals provided as input to the
          program PLTORB must be "natural orbitals", see below.

          ----------------------------------------------------------
          @OPTDEN    [MINUS=0]
                     [D/DX**2]  [D/DY**2]  [D/DZ**2]  
                     [CSTART=0.0]   [CSTOP=<cstop>]
                     [DELTA=<delta>]   [KOLOR=1]   [SIZE=1.0]
                     [GRIDS]  /  <title>
          ----------------------------------------------------------
          Keyword options are:
          MINUS  gives the number of sets of electron densities are
                 to be subtracted from the total density.  The
                 default is appropriate for a total density plot.
          D/DX**2, D/DY**2, D/DZ**2 may only be chosen if PLTORB
                 was asked to compute the orbital gradients.  In
                 that case, if none of these are selected, this
                 program will draw 1/2 times the sum of all three
                 components.  The keywords draw the square of the
                 selected component, without the 1/2 factor.
          CSTART gives the smallest magnitude contour to be drawn.
          CSTOP  gives the largest magnitude contour to be drawn.
                 The default is 1.0 for MINUS=0, 0.100 otherwise.
          DELTA  gives the algebraic contour increment, the I-th
                 contour drawn is at function values +/- I*DELTA.
                 The default is 0.05 for MINUS=0, 0.001 otherwise.
          KOLOR  gives the color of the plot.
          SIZE   is a scale factor for the plot, the default is full
                 size, 0.5 is half size, etc.
          GRIDS  causes grid values to be printed. (debugging)
          <title> is 80 characters of title information, which will
                 be put on the plot in two lines of 40 characters.

          ----------------------------------------------------------
          @PSISQR    {TWO|ONE|<occ.no.>:}
          ----------------------------------------------------------
          This card gives the electron occupation numbers of all the
          orbitals occupied in the whole molecule.  The actual
          number of orbitals is read from the whole molecule's
          PLTORB file.  If all occupation numbers are 2.0 or 1.0, a
          single shorthand keyword may be used.

          ----------------------------------------------------------
          @SUBDEN:   [TWO|ONE|<occ.no>:]
          ----------------------------------------------------------
          *** Repeat this read site MINUS times.
          This is the occupation number of each natural orbital
          occupied in a fragment of the whole molecule.  The
          meanings are the same as @PSISQR.


              The remaining input is read from the various PLTORB
          disk files.  You must run PLTORB a total of MINUS+1 times.
          The whole molecule's data is provided on unit 20, and the
          various fragments are read in from units 21, 22, 23, ...,
          with their electron occupancies provided @SUBDEN in the
          exact same order.  PLTORB must be run each time with
          exactly the same plotting plane (DENDIF verifies this).
          Since the electron density around a nucleus is very large,
          take care that your nuclei are in exactly the same spot,
          or you won't get cancellation of the core electron density
          (DENDIF does not verify this).  For example, if you want
          to compare phosphine oxide to PH3 and O, you probably want
          to force the phosphine into the same geometry this moeity
          has in H3PO.


          Before you execute:

              The input for DENDIF should be in a file XXX.DDF, and
          the MO grids from PLTORB for the total density should be
          in SCR:XXX.RHO (the XXX must match).  If you plan to
          subtract any densities to get a density difference map,
          these MO grid files SCR:AAA.RHO, SCR:BBB.RHO,... should
          also exist.

          Execution:

              On VMS type @PLT:DENDIF, on UNIX type 'dendif xxx'.
          Respond to the prompts for XXX, AAA, BBB, ...  Your
          printout (which is probably interesting only if the job
          bombs) will be XXX.LOG.

          Example input:   PLT:H2O.DDF

          Files used:

          Unit Name    Description
           1  DENINP  the card input
           2  DENLOG  the print output
          20  FOR020  total density grids (from PLTORB)
          21  FOR021  1st set of grids to subtract from FOR020
          22  FOR022  2nd set, and so on...
          All machine types use the VAX style generic names FOR020...
          Units 5 and 6 are used for screen clearing.

          Notes:

              The only orbitals whose density can be plotted are
          Natural Orbitals, because the input density matrix is
          diagonal, i.e. the occupation numbers.  Examples of NO's
          are RHF and UHF canonical or localized orbitals, ROHF
          canonical orbitals, and GVB, CI, or MCSCF natural
          orbitals.  Occupation numbers for GVB, CI, and MCSCF are
          between 0 and 2, and can be found on the GAMESS output.
