1

                                                   June 14, 1990

                   User's guide to ALIS-style free format input
                   ------ ----- -- ---- ----- ---- ------ -----

              In order to understand the input descriptions to
          programs which use a sophisticated set of free format
          input routines, you should read the first half of this
          document first!

              These free format routines were derived from the
          program system ALIS, and thus are referred to as ALIS
          style free format.   The use of these routines is
          described in the second half of this document.

              Free format input allows you to enter data without
          regard to what column it is in.  In addition, some of the
          input will be in the form of keywords, a feature which
          makes your input self-documenting.  The following
          characters can be used to separate data fields:  a blank
          space, a tab, a comma, left or right parentheses, or an
          equals sign.

              An example of a keyword input item is DELTA=0.05,
          which is two data items, the first (DELTA) being the
          keyword telling what the data is, the second (0.05) being
          the actual value you want to read in.  Sometimes the mere
          presence of a keyword sets an option true or false, in
          other words, a keyword does not always require a value.
          Because there is a keyword identifying the data items, you
          can give them in any order you like, "DELTA=0.05 NOPLOTS"
          and "NOPLOTS DELTA=0.05" are scanned exactly the same.
          Keywords can be abbreviated to four characters, and can be
          typed in any case.  Keywords which expect numeric values
          should follow the FORTRAN convention for type:  if the
          initial letter of the keyword is I-N the value must be an
          integer, other starting letters expect a floating point
          value.

              In other circumstances, you will be expected to input
          a set of numeric and/or string data items WITHOUT a
          keyword.  You must give these data items in the order
          expected by the program (but needn't be concerned with the
          exact columns, of course).

              You will be giving a set of data items on a logical
          input card in order to provide the data expected at some
          point in the program you are running.  This point in the
          program is known as a read site.  A read site is
          identified by the name of the subroutine which is reading
          the data.  In case there is more than one read site in a
          subroutine, a number is used to distinguish between read
          sites.

1

              Note that if a read site expects an integer, you must
          give an integer (if you give a floating point number, it
          will be truncated).  If the read site expects a floating
          point number, you can give it in several forms:  10.0,
          +10.0, 10, 100.0/10, 1.0D+01, and 1.0E1 are all floating
          point tens.  (The two exponential forms are exactly the
          same precision, e.g., 64 bits on a VAX).  The fractional
          form can be used to obtain full machine precision, that is
          1/3 is preferable to inputting 0.3333333.  String data
          need not be contained in single quotes (but can be, if you
          want to include embedded blanks or other separators), and
          can be typed in any case.  Giving a string when a number
          is expected is ordinarily an error (although in a few
          instances the presence of a string in place of a number is
          possible, and will trigger an alternate flow of execution
          by the program).

              If a read site expects more data items than you
          provide, the missing items are set to zero numbers, or
          blank strings, as appropriate.  Thus you need not give
          trailing zeros (but must give leading zeros).

              Note that there are three characters which mean
          something special to the free format interpreter.  These
          are the semicolon(;), the bang(!), and the greater than
          sign(>).  Do not type these by accident (for example, in a
          title card) as they will be interpreted in a way quite
          different than what you intended!

              The free format interpreter normally treats each 80
          byte physical "card" image (line) as a single logical
          card.  If a single read site expects to receive a lot of
          data items, and they won't all fit on a single physical
          card, use the continuation character (CONT defaults to >)
          to continue the logical card over more than one physical
          card.  Conversely, you may be required to give only a
          small amount of data on any given logical card.  In this
          case you may wish to combine several logical cards onto a
          single physical card, in order to keep more logical cards
          visible on a single 24 row terminal screen.  You can do
          this by using the end of card character (EOC defaults to
          ;) to separate the logical cards on a single physical
          card.  Finally, you may wish to put comments into your
          input, without having these comments interpreted as data.
          You can do this with the end of data character (EOD
          defaults to !), free format interpretation of a logical
          card ceases when this card is encountered.  A complex
          example of this might be

          > this is 5 physical cards, holding 3 logical cards.
          > note that comments can follow the CONT character
          > as well as the EOD character.
          1.0 2.0 ! numbers ;  abc  ijk  ! strings  ;  1.0   >
          2.0   -4444.9864   ! three more numbers

1

              If you want to use one of the reserved characters >;!
          as part of a data item, you can change the defaults.  This
          is accomplished by a card like this:

               SET CONT &     SET EOC :     SET EOD $

          You need not change all three items, but if you do change
          more than one you must repeat the SET.  You can use as
          many SET cards as you like, whenever you like.  Normally,
          though, you will use none, and will not type !;>'s unless
          you mean to change the free format interpretation process.

              In some cases, there can be an implied continuation,
          without your typing the CONT (>) character.  This is
          common for the first read site, which is normally keyword
          options.  Whenever the next option is scanned as a blank
          (meaning no more options were found on the current
          physical card), another logical card is read in and
          processed as more keyword options.  This process must be
          terminated somehow, normally by the use of a title card.
          Whenever the scanner finds an unrecognizable keyword, it
          assumes it has found a title, and will read the rest of
          the current logical card as a title.  Normally you will
          put titles on a new line, so as to get a full 80 column
          title.  Note:  for your title to be recognized as such, it
          cannot share its first four letters with the first four
          letters of any of the valid keywords!  (If you mistype a
          keyword, it will be taken as your title, which will
          probably cause complications and a fast abort at some
          subsequent read site encountering your real title card).

              The second circumstance in which a continuation is
          implied is if the last column of data interpreted is also
          the last scannable column of the logical card.  This is
          true if your last data item ends in column 80, or if you
          put a EOD (!) character immediately behind a data item.
          It is easy to avoid this continuation, stay out of column
          80 and keep a blank in front of your bangs.

              If you enter a card containing the letters EOF, the
          input file is considered to have reached end of file (even
          if there are more cards following the EOF card).  Do not
          enter an EOF card unless the program is capable of
          proceeding without any more data being read!

              The printout produced by a program will usually
          contain an exact echo of the input physical cards, and an
          explanation of what read sites were satisfied by the
          various logical cards.

              Concepts you now understand:  keyword, data item, read
          site, logical card, physical card, special characters
          (>!;).

1

                           Input Notation
                           ----- --------

          @XXXN denotes the read site (data is to be read AT the Nth
                read site in subroutine XXX).

          <var> is a variable the user must supply.  It might be
                an integer, floating point number, or a string.

          :     means the data item may be given more than once.
                This can appear after a variable, or after a read
                site, if the entire read site should be repeated.

          |     separates exclusive options.  You can give one or
                the other, but not both.

          {}    Braces group required items.  You must give these.
                To avoid clutter, when there is only one required
                option or value, the curly braces will be omitted.

          []    square brackets group optional items, the program
                has a reasonable default if you do not give this.

          /     If an option must follow another option, the first
                option(s) are separated from the following options
                by a slash.  (Don't confuse this with the division
                operator you can type in a numeric value.)

          You do not type the <>[]{}|:/ notational characters!

          An example:

         ------------------------------------------------------------
         @OPTPLT   NATOMS=<natoms> [DELTA=0.05] / {FORMAT FREE|<fmt>}
         ------------------------------------------------------------
         An extended description will be here....

              This means NATOMS must be specified, that DELTA is
          optional with the default value shown, and that the
          options read site must terminate with the keyword
          "FORMAT", which must be followed by the keyword FREE or an
          actual format string, but not both.

1

                  Programmers Guide to ALIS-style free format
                  ----------- ----- -- ---- ----- ---- ------

              The use of the ALIS-like routines documented below is
          unquestionably more difficult than the use of the * format
          specifier in a FORTRAN-77 READ statement.  However, users
          love it, and you will too when you switch from being a
          programmer to a user of the program you just wrote.
          Features you get with these subroutines you can't get with
          the FORTRAN-77 free format scanner:

            1) trailing zero items need not be entered.
            2) string items need not be in quotes.
            3) keywords automatically get translated to upper case,
               users can use any case they like to enter data.
            4) an echo of the input can be produced on the printout.
            5) a single data item, or an entire card can be reread.
            6) representation of numbers as a fraction.
            7) ability to imbed comment strings.
            8) sophisticated error handling.
            9) different programs have similar documentation style.

              The printout echoing feature works best if you read
          all input cards before writing anything to the print file.
          This has the built-in consequence that all input cards are
          read and checked for input error BEFORE any heavy duty
          computation begins.  Users love finding all their input
          errors before exhausting their computer bank account!  And
          you or they can easily spot their input errors, since
          every character in the input stream is echoed onto the
          printout, verbatim.

              These routines were taken from the Ames Laboratory,
          Iowa State quantum chemical program system ALIS.  The
          author and master genius behind these routines was Steve
          Elbert of Ames Lab.  They were modified somewhat by Mike
          Schmidt at North Dakota State University to bring them into
          the FORTRAN-77 era.

              The subroutines are documented on the following pages.
          For illustrative examples of the use of these routines,
          see the source code files PLT:PLTORB.FOR, PLT:MOLPLT.FOR,
          or PLT:XYPLOT.FOR.

1
          ------------------------
          SUBROUTINE OPNCRD(IR,IW)
          ------------------------
          This opens the free format scanner, and is normally called
          only once.

          IR is the unit number card data is read from, preposition
          this file yourself with a REWIND, if necessary.

          IW is the unit number for printout.  If positive, each
          physical card will be echoed to the printout, along with
          any error messages.  If negative, only error messages will
          be printed to unit ABS(IW).  If zero, no output is ever
          produced.

          ----------------------------------
          SUBROUTINE RDCARD('readsite',IEOF)
          ----------------------------------
          This subroutine makes the next logical card available for
          scanning by this readsite.

          'readsite' is an 8 character name for the read site.  This
          will normally be the subroutine name, and the number of
          the read site in that subroutine, if there is more than
          one.  This string is used in the physical and logical card
          echoing.

          IEOF.  On input, this is normally 0, if you wish to read
          the next logical card.  If it is -1 on input, the previous
          logical card is to be rescanned.  On output, IEOF equal to
          +1 means an end of file was detected.

          ---------------------------------------
          INTEGER FUNCTION IFIND('descript',IERR)
          ---------------------------------------
          Scans the current logical card for the next integer value.

          'descript' is an 8 character description of variable being
          read.  It will be printed if an error occurs while
          scanning for the integer.

          IERR.  On entry, this is normally 0, which means only an
          integer is expected.  In this case, if a string is found,
          an error message is produced.  If IERR is +30 instead, the
          detection of a string is a possibility, which will be
          handled by the calling program (do not produce an error
          message).  On exit, IERR=0 indicates an integer was
          successfully scanned.  1 indicates an error in the scan,
          almost certainly an unexpected alphameric string was
          found.

          ------------------------------------------------
          DOUBLE PRECISION FUNCTION RFIND('descript',IERR)
          ------------------------------------------------
          This scans the current logical card for the next floating
          point number.  Its arguments are analogous to IFIND.
1

          -----------------------------
          SUBROUTINE GSTRNG(STRING,LEN)
          -----------------------------
          The next character string on the current logical card is
          returned in the character variable STRING.  The scan is
          controlled by LEN.

          If LEN is negative, the STRING will be truncated to
          ABS(LEN) characters, and automatically converted to upper
          case.  Keywords are normally processed with LEN set to -4.
          Any characters in excess of ABS(LEN) typed by the user
          will be skipped over, so as not to interfere with
          subsequent IFIND's, RFIND's, GSTRNG's.  The string will be
          blank padded from behind to make up ABS(LEN) characters,
          if need be.

          If LEN is positive, the next LEN characters on the current
          logical card will be returned.  Any separators encountered
          will NOT be regarded as separators, except that leading
          blanks will not be returned.  LEN is typically +80 to read
          a title.  STRING will be blank padded to a total length of
          LEN.  STRING will not be converted to upper case.

          If LEN is a variable that is initialized to 0, the STRING
          returned will be of arbitrary length.  On exit, LEN will
          hold the actual length read.  The user MUST in this case
          type single quotes around the string, which is thus
          allowed to contain separators.  To imbed a quote in the
          returned string, the user should type two consecutive
          single quotes.  STRING will not be converted to upper
          case.

          -----------------
          SUBROUTINE REREAD
          -----------------
          This call backs the free format scanner up, so that the
          last read item can be reprocessed.  You can then choose a
          different scanning call RFIND, IFIND, or GSTRNG.

          -----------------------------
          SUBROUTINE UPCASE(STRING,LEN)
          -----------------------------
          The first LEN characters of the character variable STRING
          are to be converted to upper case.  You might want to use
          this when calling GSTRNG with a positive length.




          There is an internally used subroutine named DECODN and a
          common block named /FREEFM/.  These names should be
          avoided in your own program.

