1
 
                                                        30 Sep 1999
 
                             Graphics Software
                             -------- --------
 
                          Department of Chemistry
                           Iowa State University
                              Ames, IA 50011
 
              The GAMESS graphics package contains the following
          programs:
 
                MOLPLT  -  ball and stick molecular picture.
                MEPMAP  -  molecular electrostatic potential map.
                PLTORB  -  molecular orbital contour maps.
                DENDIF  -  total density/density difference map.
 
              The plotting programs are meant to be easily used in
          conjunction with the ab initio quantum chemistry code
          GAMESS.  GAMESS can produce a skeleton input deck for each
          of the first three programs, while DENDIF uses results from
          PLTORB.  See the input variables PLTORB and MOLPLT in
          $CONTRL, and WHERE=GRID in $ELPOT and $GRID in the GAMESS
          documentation for further information.
 
              The documentation for each of the plotting programs has
          information about their input requirements, and how to
          execute them.  Before trying any of the programs you should
          read the next bit of general information on graphics in
          this file and the general introduction to free format input
          found in FRFMT.MAN.
 
                             - - - - - - - -
 
              The programs can do graphics using two popular graphics
          languages.  PostScript is used for hardcopy, X-windows is
          used for display on screen.
 
              The XW or PS (if you have a CMYK printer) programs
          select the color by reading an integer value, often using
          the keyword KOLOR.  Color 0 is the background, so drawing
          in this color is invisible.  1 is the foreground, and 234
          is RGB.
 
             kolor  Color          kolor  Color
             -----  -----          -----  -----
               0    white            8    plum
               1    black            9    orange
               2    red             10    gray
               3    green           11    navy
               4    blue            12    violet
               5    cyan            13    brown
               6    magenta         14    pink
               7    yellow          15    sea green
 
1
 
                         --- Xwindows version ---
 
              The graphics programs run under Xwindows (XW) on just
          about any VMS or Unix workstation.  Because they use only
          the basic Xlib, they should work under any release of X,
          and any window manager you are likely to encounter.
 
              The XW programs do not use the mouse in any way, and
          do not store the plot if it is clicked away from the
          front.  It is best if the text window from which you run
          the programs is near the bottom left of the screen.  That
          way you can see any messages or prompts you receive from
          the graphics programs.  You must leave the "input focus"
          in the text window from which you run the graphics
          programs.  You signify that you are ready to clear the
          plots by hitting <return>, not clicking your rodent.
 
              If you are running on a display other than the main
          console, you may need to experiment with the call that
          opens the display.  Something like
               display = XOpenDisplay(getenv("DISPLAY"))
          in XWINDOWS.C may do the trick for you.
 

                         ---- PostScript version ----
 
              The existence of the PostScript (PS) version is due to
          Francis Muguet of Texas Tech University, who sent us the
          file POSTSCR.C, so many thanks are due to him.  Jerry Boatz
          at Edwards Air Force Base added the color PostScript.
 
              Virtually any computer should work, since it will not
          actually do any (direct) graphics.  Instead, the PS
          programs just produce an ASCII file containing the
          PostScript page description.  These files print on our
          Apple Personal LaserWriter NTR, and should print on any
          other PostScript printer.  You can preview your PS image 
          on screen if you have a PS previewer like 'dxpsview' in 
          DEC's Ultrix.
 
              The SIZE option read by each of the programs pertains
          only to hardcopy PostScript runs, not to Xwindows.
 
              Jerry used a QMS Colorscript 100 model 10 printer to
          obtain color PS plots.  He reports that the "translate"
          command should be "15 200" rather than "15 15" to avoid
          having the bottom chopped off.  You can either change the
          ASCII PS files, or the source code (two places) if you
          have this problem.
 
                              - - - - - -
 
              This completes the general introduction.  You need to
          read the rest of this document only if you are installing
          the programs, or planning to modify them.

1
 
 
                          Programmer's Introduction
                          ------------ ------------
 
              The free format keyword input is read by linking the
          file FRFMT.SRC to your program.  This file is one of the
          regular source code modules of GAMESS.  For information
          about how to call these routines, see FRFMT.MAN.
 
              The programs which draw contour maps link to the
          FORTRAN file KONTRS.CODE to do so.  For information about
          how to use KONTRS, see comments in this source file.
 
              The programs all use the same few utility routines
          which are stored in UTILS.CODE.
 
                              - - - - - - - -
 
              Graphics is inherently unportable.  There is Calcomp,
          Plot-10, GKS, Phigs, Dore, HP-GL, Xwindows, PEX,
          PostScript, and on and on and on.  Somewhere along the
          line, you have to choose one of these systems.
 
              The graphics programs described here use (as far as
          possible) only some basic Calcomp subroutine calls:  PLOT,
          FACTOR, NEWPEN, SYMBOL, NUMBER.  These programs should be
          adaptable to any Calcomp subroutine system, if you can
          still find one.  They are scarce on the ground.
 
              In addition we use two other routines, ERASE to clear
          the entire window (this is found in some Calcomp packages)
          and ZAPBOX to erase a portion of the window (this is not
          standard Calcomp at all!).
 
              The main reason for sticking with Calcomp as far as
          possible is historical:  many of these programs were first
          written when Calcomp was the most common graphics package.
          Secondly, Calcomp is a very simple graphics language, so
          it is possible to teach someone this in an hour.  Finally,
          the source programs can be written in portable FORTRAN (or
          very nearly so).
 
              To run these programs on Xwindows, it is necessary to
          write code that translates the Calcomp calls to Xwindows
          calls.  Not all functions of Calcomp are implemented yet,
          so see the source code XWINDOWS.C for details as to what
          will work.  The translation code is complete enough to
          allow MOLPLT, PLTORB, MEPMAP, and DENDIF to run just fine.
 
              Note that the Xwindows implementation uses OPENCC and
          CLOSCC to open and close the graphics window, instead of
          PLOTS and the call to PLOT(,,999).  You must also use a
          call to FLSHCC to flush the rest of your graphics buffer to
          the screen at the end of each plot.
 
1
 
              The PostScript version is implemented in much the same
          way, within POSTSCR.C.  Most of the subroutine names in
          this file are the same as in XWINDOWS.C, so you must link
          two separate executables for the two graphics protocols.
          The routines OPENPS, CLOSPS, and EJCTPS have different
          names from their Xwindows counterparts.
 
              The programs contain the strings *UNX and *VMS to
          comment out minor differences in FORTRAN dialects.  These
          four character strings must be changed to four blanks
          before compiling on your system.  Similarly, the minor
          differences between the two graphics protocols have been
          commented out by "*XW " and "*PS ".  These four character
          strings should be converted to blanks before compiling.
          Finally, the Cray requires that the lines beginning with 
          *CRY in UTILS.CODE be activated. 
 
                           - - - - - - - -
 
              List of the ASCII source files you should have:
 
                   INTRO.MAN      which is this file!
                   FRFMT.MAN      free format input documentation
                   XWINDOWS.C
                   POSTSCR.C
                   KONTRS.CODE    contouring utilities
                   UTILS.CODE     miscellaneous utilities
 
                   COMPLINK       compile and link to binaries on Unix.
 
                   DENDIF.CODE, .MAN, and a Cshell script to run it
                   MEPMAP.CODE, .MAN, and a Cshell script to run it
                   MOLPLT.CODE, .MAN, and a Cshell script to run it
                   PLTORB.CODE, .MAN, and a Cshell script to run it
 
                   C60.MOL       all these are sample inputs
                   H2O.DDF
                   H2O.ORB
                   H2O.VEC
                   H3ALOH2.MOL
                   H3PO.ORB
                   H3PO.VEC
                   SILABENZ.INP
                   SILABENZ.MEP

          you also need FRFMT.SRC, located in the usual GAMESS source
          subdirectory (not in the graphics subdirectory).
 
1

              If you have a Unix system, installation should be
          almost automatic.  Put all of the graphics files into the
          same directory, such as /u1/mike/gamess/graphics.  Remove
          the .CSH extension from the scripts, and make them
          executable, for example 'mv molplt.csh molplt' followed by
          'chmod 755 molplt'.  The compiling script 'complink' will
          automatically activate the correct FORTRAN lines, and build
          separate executables for the two graphics protocols.  Before
          using "complink", you must customize a few lines at the
          very top of it.  For example, you can choose not to compile
          the X-windows version if you don't have access to that
          hardware.  To execute the programs from any directory, 
          modify your path (for example, in your .cshrc):

               set path=($path /u1/mike/gamess/graphics).

              There is a special environment variable MACX used at
          ISU to indicate X-windows is being run on a MacIntosh.  If
          you have trouble executing the Xwindows graphics, with a
          core dump near the string compare in XWINDOWS.C, try adding
             setenv MACX false
          near the top of each of the four execution scripts, and 
             unsetenv MACX
          near the bottom.  This has proven unnecessary on the IBM
          RS/6000, but necessary on SGI, for example.

