1
                                                    May 25, 1993
                               MOLPLT

              This program draws ball-and-stick molecular figures,
          automatically centering the molecule.  Optionally, the
          program will draw a normal mode displacement at each atom.
          Once drawn on a graphics terminal, almost everything about
          the picture can be changed interactively.  The changes
          include rotation of the molecule, color and size changes,
          and rescaling of the normal mode.  Once the molecule looks
          right, the current variable values can be written back to
          disk, so that a hardcopy run may be made.

          ----------------------------------------------------------
          @RDMOL1  NATOMS=<natoms>   NKINDS=<nkinds>   [NBONDS=0]
                   [BNDLENGTH=2.0]   [BNDWIDTH=0.03]   [KOLOR=1]
                   [SIZE=1.0]    [NOBOX=0]   [VIEWDISTANCE=10.0]
                   [MODE=0] [SCALEMODE=1.0] [ICHEM3=0]  /  <title>
          ----------------------------------------------------------
          Keyword options are:

          NATOMS gives the total number of atoms.

          NKINDS gives the total number of elements.
                 Methanol has NATOMS=6 and NKINDS=3.

          NBONDS gives the total number of bonds.  If this value is
                 given as 0, all atom pairs (except H-H) which are
                 closer than BNDLENGTH are considered bonded.  If
                 greater than zero, a BONDATOMS card will be read.

          BNDLENGTH gives the maximum distance which is considered
                 bonding.  This is ignored if NBONDS is given.

          BNDWIDTH gives the "fatness" of the sticks.

          KOLOR  gives the color number for bonds and titling info.

          SIZE   allows for reducing the size of the plot.

          NOBOX  controls the drawing of a box and titles around
                 the molecule, enter 1 to skip the box and titles.

          VIEWDISTANCE gives the viewing distance.  Large values
                 give no perspective, small values give distortion.

          MODE   indicates the style of normal coordinate input.
                 The default means no normal mode is being drawn.
                 Enter -1 to give a single mode on the same card
                 as the atomic coordinates.  Enter a positive
                 number to plot that particular mode from a deck
                 of modes as punched by GAMESS by a RUNTYP=HESSIAN.

1

          SCALEMODE is a scale factor for the normal mode, if one
                 is being plotted.  2.0 will double the arrows, -1.0
                 will reverse the vibration.

          ICHEM3 activates one of three options regarding an interface
                 to Chem3D.
                 ICHEM3=0: no Chem3D file is written.
                 ICHEM3=1: a file is written in which a dummy atom is
                 positioned at the end of a normal mode displacement.
                 In Chem3D one would connect these dummy atoms to their
                 respective real atoms and set the atom radius to 0.05.
                 The "bonds" connecting dummy and real atoms would then
                 serve as normal modes.
                 ICHEM3=2: The equilibrium structure is displaced in 
                 in five equally spaced increments along the normal
                 mode and in each direction.  The resulting 11 structures
                 can then be read into Chem3D and animated.

          <title> is 80 characters of titling information, put on
                 the plot in two lines of 40 characters.   It must
                 follow all other keywords.

          ----------------------------------------------------------
          @RDMOL 2:   <atom> <kolor> <size>
          ----------------------------------------------------------
          *** repeat this card <nkinds> @RDMOL 1 times.
          <atom>  is the chemical symbol, e.g. C, As, or U.
          <kolor> is the color number of this element. See below.
          <size>  is the radius of the ball for this element.
                  Try a value of 0.2 to 0.5 or so.

          ----------------------------------------------------------
          @RDMOL 3:   <atom> <x> <y> <z> [<dx> <dy> <dz> [<atmass>]]
          ----------------------------------------------------------
          *** repeat this card <natoms> @RDMOL 1 times.
          <atom> is the chemical symbol of this atom.
          <x>, <y>, <z> are the Cartesian coordinates of this atom.
          <dx> <dy> <dz> are the normal mode displacements of this
          atom, in Cartesian coordinates.  <atmass> is the mass of
          this atom, if not given it defaults to the mass of the
          most abundant isotope.  Give these values only if MODE=-1.

          ----------------------------------------------------------
          @RDMOL 4   BONDATOMS {<iatom> <jatom>}:
          ----------------------------------------------------------
          The keyword BONDATOMS is followed by a list of atom pairs
          which are to be connected by sticks.   Skip this card if
          NBONDS was zero @RDMOL 1.

1

          ----------------------------------------------------------
          @RDMOL 5,...
          ----------------------------------------------------------
          The remaining cards are given only if MODE is positive.
          The input is given in EXACTLY the format it was punched by
          GAMESS, starting with a card that says "ATOMIC MASSES".
          It is smart to leave all the modes in the input deck, so
          that you can draw any one of them by changing only MODE.

                                 * * *

              If you are running MOLPLT on a graphics terminal, a
          help screen will be displayed after the molecule is
          plotted.  By typing the commands shown on this menu, you
          can change everything about the plot (except <natoms>,
          <nkinds>, <nbonds>, <mode>, <kolor>, and the title).  For
          example, you can rotate the molecule, change an atom's
          ball size or color, or change the viewing perspective.
          After entering one or more changes, the DRAW command will
          redisplay your molecule.  Once your molecular editing is
          finished, type WRITE to put the current input settings
          into a disk file (see below for a caution about the WRITE
          command).  You can then do a hardcopy run, if desired, of
          this final view.

          Before you execute:

             Prepare an input deck as described above in XXX.MOL.

          Execution:

             On VMS, type @PLT:MOLPLT and answer the prompt for XXX.
             On UNIX, type 'molplt xxx'.

          Example input:

             PLT:H3ALOH2.MOL

          Files:

          Unit Name   Description
           1  MOLPLT  the card input.
          Units 5 and 6 are used for screen clearing prompts.

          Notes:

              1.  This program was adapted from the graphics portion
          of the electron diffraction analysis program EDPROG from
          Professor Hilderbrandt's group at NDSU in 1983.

1

              2.  You can temporarily suspend bond length drawing by
          entering BNDWIDTH as zero.  Likewise, entering SCALEMODE
          as zero will suppress the normal mode arrows.  This can
          speed up the redrawing process, until you get the molecule
          rotated just right.  Then enter nonzero values for
          BNDWIDTH or SCALEMODE.

              3.  You can enter more than one rotation before
          reDRAWing, but it can be difficult to anticipate what the
          cumulative effect will be.  After every rotation, the
          current axes are redefined to point as shown on the help
          screen.

              4.  Program limitations:  500 atoms, 2000 bonds.
          These are dimension limits, and are easily changed.  All
          104 elements are known to this program.  You cannot
          distinguish between types of carbons, however, all C's
          will be the same color and ball size.

              5.  Units:  All distances are considered to be in the
          same system of units, such as Bohr, pm, or Angstroms
          (including BNDLENGTH, BNDWIDTH, and VIEWDISTANCE).  The
          defaults for the three keywords are best suited to
          Angstrom units, however.  If your molecule does not appear
          to have enough perspective, decrease VIEWDISTANCE, and
          conversely.

              6.  Colors:  The help screen will show you the colors
          numbers available on your graphics terminal.  For more
          information, see PLT:INTRO.MAN.

              7.  The WRITE subcommand:  This writes a restart deck
          to a file named RESTART.MOL that will regenerate the same
          view (including all rotations up to this point).  Note
          that any preexisting file named RESTART.MOL is destroyed
          by WRITE.  Only the currently displayed normal mode will
          be contained in this file, as it is the only one for which
          the rotations have been accumulated.

              8.  Normal modes are drawn in mass weighted Cartesians,
          but must be entered in Cartesian coordinates.  Programs
          such as GAMESS and GAUSSIAN8x print out normal modes in
          Cartesians.  Mass weighting multiplies each atom's
          displacement by the square root of the atomic mass, which
          accentuates the motion of heavy atoms.  In addition, the
          arrows are drawn starting from the surface of the balls,
          rather than the ball centers, as otherwise many of the
          displacements are too small to appear.

