                                                         May 16, 2008

                             Program PLTORB

              This program draws contour plots of molecular orbitals
          expanded in a basis of s,p,d,f, or g contracted Gaussian
          type (Cartesian or Spherical Harmonics) orbitals, or in a
          basis of s,p Slater type orbitals.  Optionally, for GTO sets
          only, the gradients of the orbitals may be plotted, instead
          of the orbital amplitudes.

               An arbitrary orientation of the plotting plane can be
          specified.  The program contains an algorithm to draw the
          orbitals with a reasonable phase, but this phase choice can
          be overridden if desired.

              The Cartesian coordinates of the nuclei are referred
          to as the fundamental, or F axes.  The plot is drawn in
          the plotting, or P axes, specifically, the Px and Py plane
          is plotted, in this fashion:

                     labeling information at top
                   ________________________________
                   |                              |
                   |                              |
                   |      ^   Px                  |
                   |      |                       |
                   |      |                       |
                   |      |                       |
                   |      |                       |
                   |       --------->   Py        |
                   |                              |
                   |______________________________|

              In the most common situation, the plane you want to
          plot is one of the axis planes of the original fundamental
          coordinate system.  In this case you can ask for the plane
          by name, for example, entering ZX makes the Px direction
          point along Fz, and the Py direction is the Fx direction.
          You can choose an arbitrary orientation of the Px,Py plane
          by inputing a translation from the F coordinate origin to
          the P coordinate origin, along with a 3x3 orthogonal
          transformation to rotate the F axes into the P axes.

              If all the orbitals which are occupied are plotted,
          the resulting information can be used to draw total
          density or density difference maps (see program DENDIF).
          If the gradients of orbitals are computed, DENDIF can
          instead draw the "kinetic energy interference density".

              Specifying the basis set according to the directions
          below is extremely tedious.  Note that GAMESS will make an
          almost complete input deck for PLTORB if you give the
          input $CONTRL PLTORB=.TRUE. $END, even for EXETYP=CHECK
          runs.  There will be a few ??'s within this file, which
          you must change to desired values.

              Output formats are PostScript and X-windows.  See
          below regarding the use of PostScript on a MacIntosh.

          Limitations:

              The orbitals are computed on a 101x101 grid mesh.  The
          molecule can contain up to 500 atoms.  A maximum of 1000
          bonds can be drawn.  The basis set can contain up to 2048
          atomic orbitals, and 512 MOs can be plotted.  The maximum
          number of Gaussian primitives in a single shell is 30.  A
          general contraction scheme for these Gaussians can be used
          with no loss of efficiency, and the maximum number of
          contractions in a shell is the number of Gaussians in that
          shell (i.e. uncontracted).  The maximum number of shells
          on an atom is 30, where PLTORB considers L shells to be
          two distinct S and P shells.  These dimensions can easily
          be changed at the top of the source code for PLTORB.

               GTO basis sets may use s,p,d,f, and g shells.
               STO basis sets may be only s,p.  This however covers
          all computations by the MOPAC module included in GAMESS.
          Orbital gradients may not be computed for STO basis sets.


          -----------------------------------------------------------
          @OPTPLT  NATOMS=<natoms>  NPLOTS=<nplots>
                   NAOS=<naos>  NMOS=<nmos>  [ANGSTROMS]
                   [KEI]  [D/DX]  [D/DY]  [D/DZ]
                   [SLATER]  [5D]  [7F]  [9G]  [HONDO]  [GAUSN] 
                   PLANE=<plane>
                   [NBONDS=0]  [DELTA=0.05]  [CUTOFF=1.0]
                   [NOBOX]  [KOLOR=1]  [SIZE=1.0]
                   [CHECK]  [GRIDS]  [NOPLOTS]
                   {FORMAT FREE|<fmt>}
          -----------------------------------------------------------
               (square brackets means a value is not required)

          Keyword option selections are:

          NATOMS     gives the total number of atoms to be input.

          NPLOTS     gives the number of molecular orbitals to be drawn.

          NAOS       gives the total numbe of contracted basis 
                     functions.

          NMOS       gives the number of MOs to be read in.  The number
                     of NMOS should be lesser or equal to that of NAOS.

          ANGSTROMS  means the atomic coordinates, and other distances
                     will be entered in Angstroms.  The default is Bohrs.

          If none of the gradient keywords KEI, D/DX, D/DY, and D/DZ
          are selected, the program will draw orbital amplitudes:

          D/DX       plot the gradient of the orbital amplitude along
          D/DY       the selected direction (in the F axis set).
          D/DZ

          KEI        plot the local "kinetic energy integrand",
                     1/2*[(d(MO)/dx)**2 + (d(MO)/dy)**2 + (d(MO)/dz)**2].
                     The integral over all space of this function is
                     the kinetic energy of the orbital.  Do not confuse
                     this function with the Schrodinger form of the
                     kinetic energy, which is a second derivative,
                     -1/2*[d2(MO)/dX2 + d2(MO)/dX2 + d2(MO)/dZ2]
                     Since it's a square, the KEI is everywhere positive.

          At most, only one of these four MO gradient keywords may
          be chosen.  Each of them computes all three MO gradients,
          and writes all of these to a disk file for possible use by
          the DENDIF program, but only one may be drawn by PLTORB.

          PLANE      tells how the plotting plane is defined.  Choose
                     one of the strings SYMBOLIC, 3ATOMS, or SPECIFIC.

          SLATER     indicates MOPAC orbitals are to be drawn, instead
                     of using Gaussian type orbitals.

          The next keywords should not be chosen if the orbitals are
          obtained from GAMESS (regardless of the setting of ISPHER).
          These are purely to match other program's choices of GTO
          ordering, and how they treat spherical harmonics.

          5D         specifies the pure basis of true basis-functions. 
          7F         For example, for 5D,the functions {2ZZ-XX-YY,XZ,YZ, 
          9G         XX-YY, XY}, in the GAUSSIAN order. The order adopted 
                     wll be that of HONDO or GAUSSIAN programme as
                     specified by the use of the relevant keywords
                     (see below).
 
          HONDO      specifies the standard order of Cartesians or Spherical 
                     Harmonics according to HONDO.  

          GAUSN      specifies the standard order of Cartesians or Spherical 
                     Harmonics according to GAUSSIAN92/DFT.

          The next set of keywords affects the appearance of the plots:

          NBONDS     tells how many atom pairs will be joined by bonds.
                     A projection of the molecule onto the plotting
                     plane will be shown if NBONDS is given correctly.

          DELTA      is the increment between successive contours.
                     For orbital amplitudes, the units are Bohr**(-3/2).
                     For orbital gradients, the units are Bohr**(-5/2).
                     For KEI, the units are Hartree/Bohr**3.

          CUTOFF     gives the largest magnitude contour to be drawn, 
                     in units of Bohr**(-3/2).  This prevents shredding
                     the plot paper near nuclear cusps.

          NOBOX      omits titling and box outline from the plot.

          KOLOR      selects the color of the monochrome plot.

          SIZE       is a scale factor for the plot.  The default is
                     full size, 0.5 means half that size.  Starting
                     with small plots may help picture quality in
                     journal articles, by pre-shrinking the images.
                     Hand editing of the "setlinewidth" value in the
                     various xxx.ps files will allow you to influence
                     the thickness of the contours.

          miscellaneous options:

          CHECK      will cause all the input to be read and checked 
                     for error speedily, no plots are produced.

          GRIDS      causes representative elements of the grids over
                     each Gaussian primitive, contracted basis function,
                     and molecular orbital to be printed out.  This is
                     a debug option, and chews up lots of paper.

          NOPLOTS    will generate the orbital amplitude maps in the
                     appropriate disk file, but will not draw a contour
                     plot of them.  This is useful if you want to make
                     a plot with the DENDIF program, but don't want to
                     see the individual orbitals.

          This must be the very last keyword selected:

          FORMAT     gives the format control which will be used to read
                     the MO expansion coefficients.  This can be FREE if
                     you are typing these by hand, or any valid FORTRAN
                     format string.  For example, GAMESS orbitals can be
                     read by a <fmt> of (5X,5F15.10).  The parentheses
                     in <fmt> are mandatory FORTRAN syntax.


          -----------------------------------------------------------
          @COORDS 1:   <symbol> <x> <y> <z>
          -----------------------------------------------------------
          *** Repeat this read site <natoms> @OPTPLT times.
          These are the Cartesian coordinates of the atom denoted by
          the string <symbol>.  The units are Bohrs, unless you
          chose ANGSTROMS @OPTPLT.


          -----------------------------------------------------------
          @COORDS 2    <plane>
          -----------------------------------------------------------
          *** Give only if PLANE=SYMBOLIC was chosen @OPTPLT.
          <plane> is one of the strings XY, YX, XZ, ZX, YZ, ZY to
          choose the orientation of the plotting axes.


          -----------------------------------------------------------
          @COORDS 3   <iatom> <jatom> <katom>
          -----------------------------------------------------------
          *** Give only if PLANE=3ATOMS was chosen @OPTPLT.
          The coordinates of atom <iatom> are taken as the origin of
          plotting plane.  Px points from <iatom> towards <jatom>.
          Py lies in the plane defined by the third atom <katom>,
          and is automatically made orthogonal to Px.


          -----------------------------------------------------------
          @COORDS 4   <t>:
          -----------------------------------------------------------
          *** Give only if PLANE=SPECIFIC was chosen @OPTPLT.
          <t> is the matrix which rotates the fundamental axes into
          the plotting axes.  The elements of <t> are the dot
          products between the unit axis vectors, given in the order
          <Fx|Px>, <Fy|Px>, <Fz|Px>, <Fx|Py>, ...  <Fz|Pz>.


          -----------------------------------------------------------
          @COORDS 5   <x> <y> <z>
          -----------------------------------------------------------
          *** Give only if PLANE=SPECIFIC was chosen @OPTPLT.
          These are the components of the translation vector from
          the fundamental axes' origin, to the origin of the
          plotting axes.  They should be in Bohrs, unless ANGSTROMS
          was chosen @OPTPLT.


          -----------------------------------------------------------
          @COORDS 6   <r> 
          -----------------------------------------------------------
          *** Give only if PLANE=SYMBOLIC or 3ATOMS was chosen @OPTPLT.
          <r> is the scalar displacement of the plotting plane above
          or below the SYMBOLIC plane (XY, XZ, ...) or 3ATOMS.  Units
          are Bohr, unless ANGSTROMS was chosen @OPTPLT.


          -----------------------------------------------------------
          @COORDS 7   <Px min>  <Px max>  <Py min>  <Py max>
          -----------------------------------------------------------
          These give the minimum and maximum values of the plotting
          axes, thereby defining the corners of the plot rectangle.
          They should be in Bohrs, unless ANGSTROMS was chosen
          @OPTPLT.   This card is required for any choice of PLANE.


          -----------------------------------------------------------
          @COORDS 8   BONDATOMS [<iatom> <jatom>]:
          -----------------------------------------------------------
          *** Give this read site if <nbonds> @OPTPLT is nonzero.
          Integer pairs telling which atoms are to be connected by a
          straight line on the plot.  Give <nbonds> pairs.  The
          keyword BONDATOMS serves to document the input, and must
          be given.

          -----------------------------------------------------------
          @GTVECS 1   PLOTMOS <MO index>:
          -----------------------------------------------------------
          These integers give the position of the orbitals which are
          to be plotted within the deck of MO coefficients provided.
          You can change the phase of the plot of a particular
          orbital by entering its index as a negative number.  The
          default phase choice corresponds to a positive sign on the
          largest magnitude MO coefficient.  If this rule does not
          give you the desired phase choice on your first run, just
          reverse it here.  The keyword PLOTMOS documents the input,
          and must be given.


          -----------------------------------------------------------
          @GTVECS 2:   <MO coefs>:
          -----------------------------------------------------------
          *** give only if FORMAT FREE was chosen @OPTPLT.
          Give the <naos> @OPTPLT expansion coefficient of every AO
          in a particular MO on a single logical card.  Then repeat
          this read site <nmos> @OPTPLT times.  Reading in formatted
          orbitals is much easier, and much less error prone than
          typing these.


          * * *   The set of read sites @BASIS 1 to @BASIS 4   * * *
          * * *    must be repeated <natoms> @OPTPLT times.    * * *

          -----------------------------------------------------------
          @BASIS 1:  <symbol> <nshells>
          -----------------------------------------------------------
          <symbol> is a string which must match that given for this
          atom @COORDS 1.  <nshells> is the number of basis shells
          to be given for this atom.


          * * *   The set of read sites @BASIS 2 to @BASIS 4   * * *
          * * *   must be repeated <nshells> @BASIS 1 times.   * * *

          -----------------------------------------------------------
          @BASIS 2:  <type> <ngaus> <ncont> [<alpha> <beta>]
          -----------------------------------------------------------
          <type> is a string which identifies this shell type.  It
          may be either S, P, or D.  <ngaus> is the number of
          primitive Gaussians in this shell, which are to be
          contracted to form <ncont> funtions.  If even-tempered
          exponents are desired, alpha and beta can be given,
          zeta(I)=alpha*beta**I.


          -----------------------------------------------------------
          @BASIS 3:  <zeta>:
          -----------------------------------------------------------
          *** skip this read site if <alpha> and <beta> were given.
          These are the Gaussian exponents, give <ngaus> values.


          -----------------------------------------------------------
          @BASIS 4:  <cont.coefs>:
          -----------------------------------------------------------
          *** repeat this read site <ncont> @BASIS 2 times.
          These are the contraction coefficients used to form the
          actual atomic basis functions.  You can use a general
          contraction scheme with no loss of efficiency in this
          program.  These coefficients are not checked for
          normalization, be very careful typing the exponents and
          contraction coefficients!

          -----------------------------------------------------------
          @PLTORB:  [<lab1> <lab2>]
          -----------------------------------------------------------
          *** repeat this read site <nplots> @OPTPLT times.
          Two forty character titles for your plot.  These are read
          with an actual FORTRAN read statement, so your second
          title must begin in column 41, exactly.  Default titles
          are generated if you omit these cards (not a good idea).

    --------------------------------------------------------------------

          Files used:

          Unit  Name     Description
           1  PLTORB  card input.
           2  PLTLOG  print output.  Useful in finding input errors,
                      it also contains numeric contour information.
           4  PLTVEC  input formatted orbitals.
           8  PRGRID  density grids for Gaussian primitives.
           9  AOGRID  density grids for contracted atomic orbitals.
          10  MOGRID  density grids for molecular orbitals.
                      The MOGRID file is useful as input to DENDIF.
          Units 5 and 6 are used for screen clearing prompts, if the
          output is X-windows.

    --------------------------------------------------------------------

          Before you execute:

              Prepare a XXX.ORB file containing the appropriate
          input cards.  If you are giving formatted MO's, prepare a
          XXX.VEC file in the same directory containing the MO
          coefficients.  This latter file should contain any number
          of explanatory comments, followed by a card containing the
          string " $VEC " before the actual MO coefficient cards.  A
          " $END " at the end of the coefficients is not needed, but
          is OK.  The two XXX's must match exactly.

          Execution:

              On UNIX:  Type 'pltorb xxx'.
              On VMS:  Type @PLT:PLTORB, and answer the questions
          concerning your choice for XXX.

              Note that it may takes a long time to draw the first
          MO plot on your screen, if you are using X-windows to see
          the images interactively.  So please wait patiently.
          Fortunately, subsequent plots pop up very quickly, as
          the AO grids are on disk for rapid re-use.

    --------------------------------------------------------------------

          Example input:

              PLT:H2O.ORB and PLT:H2O.VEC (taken from GAMESS' EXAM8)
              PLT:H3PO.ORB AND PLT:H3PO.VEC (former is listed below)

          An input example, stemming from GAMESS' exam26.inp:

          !  Plot the RHF/3-21G* Boys localized orbitals
          !  for phosphine oxide.
          !  You can see these orbitals in the paper by M.W.Schmidt,
          !  S.Yabushita, M.S.Gordon  J.Phys.Chem. 88, 382-389(1984)
          !
          NATOMS=5   NAOS=34   NMOS=13   NPLOTS=3   NBONDS=4
          KOLOR=2  PLANE=SPECIFIC  ANGSTROMS
          FORMAT (5X,5E15.10)
          P
          O 0.0000000000   0.0000000000   1.4701000000
          H -0.6167964315  1.0683222754   -0.6421021244
          H -0.6167964315 -1.0683222754   -0.6421021244
          H  1.2335928631  0.0            -0.6421021244
          -1 0 0   0 0 1   0 1 0   ! xz plane, with x reversed
          0 0 0
          -2.0  3.0   -2.5  3.0
          BONDATOMS  1 2    1 3   1 4    1 5
          PLOTMOS  7 10 11   ! these lie in the xz plane
          >     Phosphorus 3-21G*(6d)
          P 8
          s 3 1 ; 1054.90 159.195 34.5304 ; 0.0655407 0.384036 0.674541
          s 3 1 ; 44.2866 10.1019 2.73997 ; -0.102130 0.0815922 0.969788
          p 3 1 ; 44.2866 10.1019 2.73997 ; 0.110851 0.456495 0.606936
          s 2 1 ; 1.21865 0.395546 ; -0.371495 1.27099
          p 2 1 ; 1.21865 0.395546 ; 0.0915823  0.934924
          s 1 1 ; 0.122811 ; 1.0
          p 1 1 ; 0.122811 ; 1.0
          d 1 1 ; 0.55 ; 1.0
          >     Oxygen 3-21G
          O 5
          S 3 1 ; 322.037  48.4308 10.4206 ; 0.059239 0.351500 0.707658
          S 2 1  ; 7.402940  1.576200  ; -0.404453 1.22156
          P 2 1  ; 7.402940  1.576200  ; 0.244586  0.853955
          S 1 1  ; 0.373684  ;  1.0
          P 1 1  ; 0.373684  ;  1.0
          >    Hydrogen -21G, INCLUDING scale factor
          H  2
          S 2 1 ; 5.447178  0.824547 ; 0.156285 0.904691
          S 1 1 ; 0.183192 ; 1.0
          >    Hydrogen -21G, INCLUDING scale factor
          H  2
          S 2 1 ; 5.447178  0.824547 ; 0.156285 0.904691
          S 1 1 ; 0.183192 ; 1.0
          >    Hydrogen -21G, INCLUDING scale factor
          H  2
          S 2 1 ; 5.447178  0.824547 ; 0.156285 0.904691
          S 1 1 ; 0.183192 ; 1.0
          H3PO localized orbital
          H3PO localized orbital
          H3PO localized orbital

    --------------------------------------------------------------------

          note: Macintosh applications have grown increasingly reluctant
                to accept PostScript files.
       
                The simplest way to use PostScript files is to upgrade
                to OS X 10.5, where the 'preview' program has gained
                the ability to read in .ps files, converting to .pdf
                files, just by clicking on them.  Multiple images in
                a single .ps file present no difficulties.

                Note that you can edit the 'setlinewidth' value in the
                generated PostScript file to change line thickness.

                A more difficult way around this is to use the 'convert'
                program contained in the ImageMagick package.  You can
                convert a PostScript file into the "portable network
                graphics" format using SIZE=0.3333 and NOBOX above, then
                  convert -crop 0x0 -density 300x300 xxx.ps png:page
                This bursts multiple page PS files into separate
                files called page.0, page.1 which are easily renamed
                to have a .png extension:
                   #!/bin/csh
                   #         a script to "chop" PostScript
                   set file=$1
                   if (-e $file.ps) then
                      convert -crop 0x0 -density 300x300 \
                          $file.ps png:page
                      foreach fn (page.*)
                         set num=$fn:e
                         mv page.$num $file.$num.png
                      end
                   endif
                These can then be opened with the MAC OS X program
                named 'preview', and thence pasted into Word, e.g.

                Recently, the ImageMagik package seems to have become
                more difficult to install, and lost support for PNG.

                ChemDraw, under Mac OS 9, can import PICT files, via
                the Preview program in Mac OS X.  To do this, change
                png -> pict in two places above.  Other programs may
                like 'jpeg'.
