namespace roots4 {

    static const int N = 4;
    static const TYPE__ PIE4 = 0.785398163397448;

    constant__
    TYPE__ R4[N] = { 0.145303521503316, 1.33909728812636, 3.92696350135829, 8.58863568901199 };

    constant__
    TYPE__ W4[N] = { 1.0, 0.234479815323517, 0.0192704402415764, 2.25229076750736e-4 };

    template<int N, int L, int M>
    BOOST_GPU_ENABLED
    void evaluate2(TYPE__ X, TYPE__ *R, TYPE__ *W,
		   const TYPE__ (&C)[N][L], const TYPE__ (&D)[N][M]) {
	for (int a = 0; a < N; ++a) {
	    TYPE__ p = 0.0;
	    TYPE__ q = 0.0;
	    for (int i = M-1; i >= L;  --i) {
		q = (q + D[a][i])/X;
	    }
	    for (int i = L-1; i >= 0;  --i) {
		p = (p + C[a][i])/X;
		q = (q + D[a][i])/X;
	    }
	    R[a] += p;
	    W[a] += q;
	}
    }


    template<int L, int M>
    BOOST_GPU_ENABLED
    void evaluate2(TYPE__ X, TYPE__ &R, TYPE__ &W,
		   const TYPE__ (&C)[L], const TYPE__ (&D)[M]) {
	    TYPE__ p = 0.0;
	    TYPE__ q = 0.0;
	    for (int i = M-1; i >= L;  --i) {
		q = (q + D[i])/X;
	    }
	    for (int i = L-1; i >= 0;  --i) {
		p = (p + C[i])/X;
		q = (q + D[i])/X;
	    }
	    R += p;
	    W += q;
    }

    template<int n>
    BOOST_GPU_ENABLED
    TYPE__ evaluate0(TYPE__ X, const TYPE__ (&C)[n]) {
	TYPE__ p = 0.0;
// 	for (int i = n - 1; i > 0; --i) {
// 	    p = (p + C[i])/X;
//	}
	TYPE__ q = X;
	p = C[n-1];
	for (int i = n-2; i > 0; --i) {
	    p += q*C[i];
	    q *= X;
	}
	p /= q;
	return (p + C[0]);
    }







    namespace x0 {
	constant__
	TYPE__ R_CP[4][2] = {{ 0.0348198973061471, -0.00409645850660395 },
			     { 0.381567185080042, -0.0448902570656719 },
			     { 1.73730726945891, -0.204389090547327 },
			     { 11.8463056481549, -1.39368301742312 }};
	constant__
	TYPE__ W_CP[4][2] = {{ 0.362683783378362, -0.0313844305713928 },
			     { 0.313706645877886, -0.0898046242557724 },
			     { 0.222381034453372, -0.129314370958973 },
			     { 0.101228536290376, -0.0828299075414321 }};
    } // namespace x0

    namespace x0to1 {
	constant__
	TYPE__ R_CP[4][8] = {{ 0.0348198973061469, -0.00409645850658433, 3.5292130876988E-4, -2.61203523522184E-5, 1.72365935872131E-6, -1.01756452250573E-7, 5.19765728707592E-9, -1.95309614628539E-10 },
			     { 0.381567185080039, -0.0448902570678178, 0.003226979163176, -1.417298563884E-4, 1.270981734393E-6, 3.07583114342365E-7, -1.89554881382342E-8, 0.0 },
			     { 1.73730726945889, -0.204389090525137, 0.0103825827346828, -7.91549618884063E-5, -1.1364489566232E-5, -2.58341529013893E-7, 3.36524958870615E-8, 1.77280535300416E-9 },
			     { 11.8463056481543, -1.39368301737828, 0.04722855585715, 1.679007454539E-4, 3.428685057114E-6, -2.4948073307246E-7, -5.61188882415248E-8, 0.0 }};
	constant__
	TYPE__ W_CP[4][11] = {{ 0.362683783378335, -0.0313844305680096, 0.00306548909776613, -2.94268428977387E-4, 2.68880044371597E-5, -2.33305875372323E-6, 1.88015570196787E-7, -1.14649303201279E-8, 0.0, 0.0, 0.0 },
			      { 0.313706645877886, -0.0898046242565811, 0.0191883866626681, -0.00326956188125316, 4.74241566251899E-4, -6.05367572016373E-5, 6.93779646721723E-6, -7.20045285129626E-7, 6.54963481852134E-8, -4.11720483772634E-9, 0.0 },
			      { 0.222381034453369, -0.129314370962569, 0.0428670143840073, -0.0102477820460278, 0.00194431864731239, -3.08040221166823E-4, 4.20363420922845E-5, -5.0167562840822E-6, 5.07238960340773E-7, -3.41688436990215E-8, 0.0 },
			      { 0.101228536290376, -0.0828299075413889, 0.034879109737737, -0.00999791027771119, 0.00218417516259781, -3.86645606718233E-4, 5.76337430816E-5, -7.42236921061E-6, 8.359072409485E-7, -7.9458596331012E-8, 4.99660550769508E-9 }};
    } // namespace x0to1

    namespace x1to5 {
	constant__
	TYPE__ R_CP[4][11] = {{ 0.0251198234505021, -0.00253262912046853, 1.88796581246938E-4, -1.23118059980833E-5, 7.29407420660149E-7, -4.03076426299031E-8, 2.046819017845E-9, -9.163164161821E-11, 4.06854369667E-12, -1.33273068108777E-13, -1.48570633747284E-15 },
			      { 0.272276489515713, -0.0291205805373793, 0.00208048885251999, -1.08694174399193E-4, 3.48848942324454E-6, 1.50083186233363E-8, -1.048063352259E-8, 6.844424214735E-10, -3.821500128045E-12, -2.29772605964836E-12, 1.35830583483312E-13 },
			      { 1.21449092319186, -0.145505469175613, 0.0090355146956832, -2.16552440036426E-4, -9.52388379435709E-6, 5.1592957583012E-7, 3.654087802817E-8, -2.153585661215E-9, -1.482277886411E-10, 1.07461812944084E-11, 5.02799392850289E-13 },
			      { 8.0950202861178, -1.10559909038653, 0.0487791531990593, 1.49335941252765E-4, -1.07481314670844E-5, -1.95670833237101E-6, -1.448228963549E-7, -2.213111836647E-9, 7.542387436125E-10, 6.41492397277798E-11, -1.08510370291979E-12 }};
	constant__
	TYPE__ W_CP[4][16] = {{ 0.289898651436026, -0.0187588361833659, 0.00141357961729531, -1.08989176177409E-4, 8.168349266115E-6, -5.9335680796E-7, 4.148972684255E-8, -2.799399389539E-9, 1.862334710665E-10, -1.186387548048E-11, 7.586695071068E-13, -4.65801912689961E-14, 0.0, 0.0, 0.0, 0.0 },
			      { 0.156247249979288, -0.0288982669486183, 0.00481181506827225, -6.64149238804153E-4, 8.04372147732379E-5, -8.77829235749024E-6, 8.77529464577E-7, -8.120186517E-8, 7.00629596296E-9, -5.673270062669E-10, 4.32190875661E-11, -3.116258693847E-12, 2.25644205432182E-13, -1.46345073267549E-14, 0.0, 0.0 },
			      { 0.0485368861938873, -0.0209400418772687, 0.00575223633388589, -0.00118791896897934, 2.00515819789028E-4, -2.88665153269386E-5, 3.64018881086111E-6, -4.0946283547147E-7, 4.16265847927498E-8, -3.86354139348735E-9, 3.299685839012E-10, -2.60513573901E-11, 1.919270015269E-12, -1.40541322766087E-13, 9.06812118895365E-15, 0.0 },
			      { 0.00966077262223353, -0.00716227030134947, 0.00281330044426892, -7.64560567879592E-4, 1.60106988333186E-4, -2.73816413291214E-5, 3.96650392371311E-6, -4.99048696190133E-7, 5.554146993491E-8, -5.545047534808E-9, 5.021343560166E-10, -4.16115945968E-11, 3.173422008953E-12, -2.249993780112E-13, 1.57857099317175E-14, -9.74835552342257E-16 }};
    } // namespace x1to5

    namespace x5to10 {
	constant__
	TYPE__ R_CP[4][13] = {{ 0.0166630865869375, -0.00137983082233081, 8.42824204233222E-5, -4.60301761310921E-6, 2.37835295639281E-7, -9.97272656345253E-9, 5.090355371676E-10, -2.92722935535E-11, 3.462236347446E-13, -6.27892383644164E-15, 4.64217329776215E-15, 0.0, 0.0 },
			      { 0.174853819464285, -0.0157769317127372, 0.00100967602595557, -5.35837089462592E-5, 2.39156093611106E-6, -6.10898827887652E-8, 8.484275604612E-10, -6.149155555753E-12, -1.446314544774E-11, 8.47635639065744E-13, 2.93981127919047E-14, 0.0, 0.0 },
			      { 0.720206142703162, -0.0795013029486684, 0.00554843378106589, -2.54617989427762E-4, 4.856768455119E-6, 4.327249251331E-7, -3.159991002539E-8, -5.82203865678E-10, 1.027082960169E-10, -2.695740446312E-12, -6.4004177666702E-14, 2.93523563363E-14, 0.0 },
			      { 4.11207530217806, -0.666871297428209, 0.0469716410901162, -6.26495899187507E-4, -7.50249313713996E-5, -1.39428366421645E-6, 3.34382940759405E-7, 1.84347052385605E-8, -1.476849808675E-9, -1.380635298784E-10, 5.764015756615E-12, 7.68943641360593E-13, -1.62212382394553E-14 }};
	constant__
	TYPE__ W_CP[4][16] = {{ 0.226696066029591, -0.0105583210553392, 5.72164211151013E-4, -3.33474893152939E-5, 1.959098751715E-6, -1.039220021671E-7, 6.36696254699E-9, -3.672235069444E-10, 1.403341829454E-11, -9.131223418888E-13, 6.91838935879598E-14, -1.65995045235997E-15, 0.0, 0.0, 0.0, 0.0 },
			      { 0.0850218447733457, -0.00814594214284187, 9.69632496710088E-4, -9.86368311253873E-5, 9.08621687041567E-6, -7.83008889613661E-7, 6.21997763513E-8, -4.698730937661E-9, 3.428545616603E-10, -2.33252225611E-11, 1.507864898748E-12, -9.657033089714E-14, 6.25708409149331E-15, -3.57248951192047E-16, 0.0, 0.0 },
			      { 0.0113250730954014, -0.00255138844587555, 5.03162624754434E-4, -7.79566003744742E-5, 1.04189803544936E-5, -1.23673915616005E-6, 1.31949431805798E-7, -1.28771698573873E-8, 1.16034263529672E-9, -9.69039768312637E-11, 7.555896810069E-12, -5.508918529823E-13, 3.788890667676E-14, -2.6851226592841E-15, 1.64742458534277E-16, 0.0 },
			      { 5.26543779837487E-4, -2.78777909813289E-4, 9.00474771229507E-5, -2.11366761402403E-5, 3.95841149373135E-6, -6.19785782240693E-7, 8.35835975882941E-8, -9.91517881772662E-9, 1.050565098393E-9, -1.006088923498E-10, 8.79351266489E-12, -7.067105402134E-13, 5.234734676175E-14, -3.626606654097E-15, 2.57193722698891E-16, -1.55714130075679E-17 }};
    } // namespace x5to10

    namespace x10to15 {
	constant__
	TYPE__ R_CP[4][13] = {{ 0.0114189319050009, -7.87855975560199E-4, 4.15083811185831E-5, -1.61512612564194E-6, 7.72794187755457E-8, -5.20644072732933E-9, 8.06987313467541E-11, 1.30391406991118E-11, 7.006511663249E-13, -1.378685560217E-13, -5.599125915431E-15, 8.0356880573916E-16, 4.94869622744119E-17 },
			      { 0.115825965127958, -0.00868438439874703, 4.92341968336776E-4, -2.02362185197088E-5, 9.25750831481589E-7, -5.97332993206797E-8, 8.78470199094761E-10, 1.90712434258806E-10, 3.910179118937E-12, -1.613630106295E-12, -5.446260182933E-14, 1.06390248099712E-14, 4.89224285522336E-16 },
			      { 0.433467200855434, -0.0399327850801083, 0.00270279176970044, -1.25858350034589E-4, 4.97744404018E-6, -2.519549641933E-7, 4.499058798868E-10, 1.660828868694E-9, -4.781797525341E-11, -9.051094103059E-12, 1.12328861406073E-13, 6.12419396208408E-14, 0.0 },
			      { 1.82835655238235, -0.278953904330072, 0.0280539673938339, -0.00158522208889528, 9.66961790843006E-6, 5.02333087806827E-6, -1.84530195217118E-7, -2.01186401974027E-8, 1.576976911942E-9, 6.074107718414E-11, -1.001926833832E-11, -4.72757262693062E-14, 4.63414725924048E-14 }};
	constant__
	TYPE__ W_CP[4][15] = {{ 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 },
			      { 0.0601396183129168, -0.00294484050194539, 2.5239673033234E-4, -2.08065576105639E-5, 1.356478091922E-6, -8.307159819228E-8, 6.287255934781E-9, -4.203948834175E-10, 1.576841731919E-11, -6.842418230913E-13, 1.04126809657554E-13, -6.22272689880615E-15, 0.0, 0.0, 0.0 },
			      { 0.00542313365864597, -4.67067112993427E-4, 6.88603417296672E-5, -8.08708393262321E-6, 7.52380085447161E-7, -6.69965691739299E-8, 6.116545396281E-9, -4.933988617784E-10, 3.372127423047E-11, -2.413554618391E-12, 1.881303962576E-13, -1.148797566469E-14, 5.94344180261644E-16, -4.1956914545948E-17, 0.0 },
			      { 8.50290130067818E-5, -1.74648169719173E-5, 4.12159381310339E-6, -7.27634957230524E-7, 1.06527318142151E-7, -1.39237504892842E-8, 1.63738403295718E-9, -1.71987745310181E-10, 1.64090830181013E-11, -1.45501321259466E-12, 1.194719074934E-13, -8.936002188168E-15, 6.274018198326E-16, -4.63389683098251E-17, 2.90401781000996E-18 }};
	constant__
	TYPE__ W0_CP[4][4] = {{ -2.1916512131607E-5, -0.49893752514047, 0.22991849164985, -0.18784686463512 },
			      { 0.0, 0.0, 0.0, 0.0 },
			      { 0.0, 0.0, 0.0, 0.0 },
			      { 0.0, 0.0, 0.0, 0.0 }};
    } // namespace x10to15

    namespace x15to20 {
	constant__
	TYPE__ R_CP[4][13] = {{ 0.00834977776583956, -4.68648206591515E-4, 2.39030487004977E-5, -9.32738632357572E-7, 1.67559587099969E-8, 2.43865205376067E-10, 6.71083474044549E-11, -1.24330365320172E-11, 4.396602872143E-13, 5.820231579541E-14, -6.149849164164E-15, -1.12860600219889E-16, 4.36701759531398E-17 },
			      { 0.082602060202678, -0.00496812745851408, 2.71252453754519E-4, -1.14710398652091E-5, 2.4748571014312E-7, 2.42471442836205E-9, 5.95451479522191E-10, -1.39571683725792E-10, 6.4326967296E-12, 5.766105220086E-13, -7.775156445127E-14, -2.60732537093612E-16, 4.98913142288158E-16 },
			      { 0.288068671894324, -0.0205062147771513, 0.00132129867629062, -6.76512715080324E-5, 2.09563208958551E-6, -2.79188977451042E-9, 3.48789978951367E-10, -5.54336148667141E-10, 4.615806713055E-11, 1.186495793471E-12, -4.316925145767E-13, 1.48840394311115E-14, 1.91498302509009E-15 },
			      { 0.954714798156712, -0.101410568057649, 0.0096609090298555, -7.61738385590776E-4, 4.41413815691885E-5, -1.28835028104639E-6, -5.86635622821309E-8, 9.45486578503261E-9, -4.258722866437E-10, -1.26673449328E-11, 2.826607936174E-12, -1.12483395714468E-13, -5.43697691672942E-15 }};
	constant__
	TYPE__ W_CP[4][14] = {{ 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 },
			      { 0.0497836392625268, -0.00148201933009105, 7.74065155353262E-5, -5.49390160829409E-6, 3.98295476005614E-7, -2.11964170928181E-8, 4.98930345609785E-10, 9.04483676345625E-12, 1.765194089338E-12, -4.498350984631E-13, 2.563712856363E-14, 1.16661114435809E-15, -1.865060577297E-16, 0.0 },
			      { 0.00412615396191829, -1.42181943986587E-4, 1.1921069767316E-5, -1.36790720600822E-6, 1.31381116840118E-7, -8.67270669346398E-9, 3.49977768819641E-10, -1.29816917658823E-11, 1.944339743818E-12, -2.507452792892E-13, 1.349020069254E-14, 2.68748367250999E-16, -5.54451040921657E-17, 0.0 },
			      { 4.94171300536397E-5, -2.40050045173721E-6, 3.57005361100431E-7, -5.63374555753167E-8, 6.82309323251123E-9, -6.35435561050807E-10, 5.086829642731E-11, -4.289542980767E-12, 4.082150659615E-13, -3.601794386996E-14, 2.411195002314E-15, -1.157318032236E-16, 7.53541779268175E-18, -7.56882223582704E-19 }};
	constant__
	TYPE__ W0_CP[4][3] = {{ -6.0156581186481e-5, -0.4969524146449, 0.1962326414943 },
			      { 0.0, 0.0, 0.0 },
			      { 0.0, 0.0, 0.0 },
			      { 0.0, 0.0, 0.0 }};
    } // namespace x15to20

    namespace x20to35 {
	constant__
	TYPE__ R_CP[4][7] = {{ -129194.382386499, 10595.1216669313, -522.799159267808, 15.4330657903756, -0.236954961381262, 0.00127267770241379, -4.45711399441838E-5 },
			     { 5386142.11391604, -316847.570511637, 12512.0495802096, -338.29693876399, 6.35653573484868, -0.0785617372254488, 0.0 },
			     { 16041939.0230055, -950626.66339013, 37515.1841595736, -1002.00731304146, 18.4122184400896, -0.237900485051067, 0.0 },
			     { 2968179.40164703, -290517.939780207, 17083.0039597097, -654.944248734901, 15.7496131755179, -0.364479545338439, -6.00691586407385E-4 }};
	constant__
	TYPE__ R_CR[4][3] = {{ 872975.373557709, -2511772.35556236, 0.0 },
			     { -58711900.5093822, 370104713.293016, -1024274661.27427 },
			     { -172465289.687396, 1066259150.44526, -2881390146.51985 },
			     { -16494452.2586065, 34905969.8304732, 0.0 }};
	constant__
	TYPE__ W0_CR[] = { 6.0156581186481e-5, 0.4969524146449, 0.1962326414943 };
    } // namespace x20to35

    namespace x20to25 {
	constant__
	TYPE__ W_CP[4][8] = {{ 6.0156581186481e-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 },
			     { 767135.400969617, -62705.4715090012, 3152.06108877819, -100.464709786287, 2.07797425718513, -0.0353899555749875, 7.29841848989391E-4, 0.0 },
			     { -2815.01182042707, -6214.1984584509, 499.169195295559, -19.694378600654, 0.462186525041313, -0.00916785337967013, 2.36392855180768E-4, 0.0 },
			     { -6144.79071209961, 977.683627474638, -87.3165934223603, 4.80006136831847, -0.166538571864728, 0.00351416601267, -3.81542906607063E-5, 2.33766206773151E-7 }};
	constant__
	TYPE__ W_CR[4][3] = {{ 0.4969524146449, 0.1962326414943, 0.0 },
			     { -5260743.91316381, 15472124.6264919, 0.0 },
			     { 1136732.98305631, -13411346.4389309, 52144505.3212414 },
			     { 16600.094511764, 0.0, 0.0 }};
    } // namespace x20to25

    namespace x25to35 {
	constant__
	TYPE__ W_CP[4][7] = {{ 6.0156581186481e-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 },
			     { 767135.400969617, -62705.4715090012, 3152.06108877819, -100.464709786287, 2.07797425718513, -0.0353899555749875, 7.29841848989391E-4 },
			     { -2815.01182042707, -6214.1984584509, 499.169195295559, -19.694378600654, 0.462186525041313, -0.00916785337967013, 2.36392855180768E-4 },
			     { 55.5297573149528, -7.11108633061306, 0.309871652785805, -0.00378812134013125, 2.35072857922892E-4, -7.58735928102351E-5, 5.74245945342286E-6 }};
	constant__
	TYPE__ W_CR[4][3] = {{ 0.4969524146449, 0.1962326414943, 0.0 },
			     { -5260743.91316381, 15472124.6264919, 0.0 },
			     { 1136732.98305631, -13411346.4389309, 52144505.3212414 },
			     { 0.0, 0.0, 0.0 }};
    } // namespace x25to35

    namespace x35to53 {
	constant__
	TYPE__ R_CP[4][3] = {{ 0.0174725309199384, -6.88846864931685E-4, -4.075575259146E-5 },
			     { 0.184336760556262, -0.00909231717268466, -3.62569791162153E-4 },
			     { 0.608784033347757, -0.0449822013469279, -9.65842534508637E-4 },
			     { -0.750238795695573, -0.119108256987623, -0.00219135070169653 }};
	constant__
	TYPE__ W_CP[4][3] = {{ 0.0, 0.0, 0.0 },
			     { 3.28297971853126E-4, -7.8918728380489E-5, 5.7663198200099E-6 },
			     { 0.0209857151617436, -0.00377489954837361, 2.0829496985723E-4 },
			     { 0.0814504890732155, -0.0126711744680092, 6.16374517326469E-4 }};
    } // namespace x35to53


    BOOST_GPU_ENABLED
    inline void evaluate(TYPE__ X, TYPE__ (&R)[4], TYPE__ (&W)[4]) {
#define sum4_(W) ((W)[3] + (W)[2] + (W)[1])

	TYPE__ w0 = sqrt(PIE4/X);

	if (X > 53.0) {
	    divide<4>(R, X, R4);
	    scale<4>(W, w0, W4);
	    W[0] -= sum4_(W);
	    return;
	}

	const TYPE__ e = exp(-X);

	if (X > 35.0) {
	    polynomial::evaluate2(X, R, W, x35to53::R_CP, x35to53::W_CP);
	    TYPE__ eX4 = e*(X*X*X*X);
	    scale_add(eX4, R, W, X, R4, w0, W4);
	    W[0] -= sum4_(W);
	}
	else if (X > 25.0) {
	    polynomial::evaluate2(X, R, W, x20to35::R_CP, x25to35::W_CP);
	    evaluate2(X, R, W, x20to35::R_CR, x25to35::W_CR);
	    scale_add(e, R, W, X, R4, w0, W4);
	    W[0] -= sum4_(W);
	}
	else if (X > 20.0) {
	    polynomial::evaluate2(X, R, W, x20to35::R_CP, x20to25::W_CP);
	    evaluate2(X, R, W, x20to35::R_CR, x20to25::W_CR);
	    scale_add(e, R, W, X, R4, w0, W4);
	    W[0] -= sum4_(W);
	}
	else if (X > 15.0) {
	    TYPE__ y =  X - 17.5;
	    polynomial::evaluate2(y, R, W,  x15to20::R_CP, x15to20::W_CP);
	    W[0] = e*evaluate0(X, x15to20::W0_CP[0]) + w0 - sum4_(W);
	}
	else if (X > 10.0) {
	    TYPE__ y =  X - 12.5;
	    polynomial::evaluate2(y, R, W,  x10to15::R_CP, x10to15::W_CP);
	    W[0] = e*evaluate0(X, x10to15::W0_CP[0]) + w0 - sum4_(W);
 	}
	else if (X > 5.0)
	    polynomial::evaluate2(TYPE__(X-7.5), R, W, x5to10::R_CP, x5to10::W_CP);
	else if (X > 1.0)
	    polynomial::evaluate2(TYPE__(X-3.0), R, W, x1to5::R_CP, x1to5::W_CP);
	else if (X > 3e-7)  polynomial::evaluate2(X, R, W, x0to1::R_CP, x0to1::W_CP);
	else polynomial::evaluate2(X, R, W, x0::R_CP, x0::W_CP);

	change_variable<4>(R);

    }

    BOOST_GPU_ENABLED
    inline void evaluate(TYPE__ X, TYPE__ *sR, TYPE__ *sW,
			 const unsigned short thread) {

	/* do not pass constant address directly to functions */
	const TYPE__ &R4 = roots4::R4[thread];
	const TYPE__ &W4 = roots4::W4[thread];

	TYPE__ &R = sR[thread];
	TYPE__ &W = sW[thread];

	TYPE__ w0 = sqrt(PIE4/X);

	if (X > 53.0) {
	    R = R4/X;
	    W = w0*W4;
	    if (thread == 0) W -= sum4_(sW);
	    return;
	}

	const TYPE__ e = exp(-X);

	if (X > 35.0) {
	    namespace range = x35to53;
	    const TYPE__ (&C)[3] = range::R_CP[thread];
	    const TYPE__ (&D)[3] = range::W_CP[thread];
	    evaluate1(X, R, W, C, D);
	    TYPE__ eX4 = e*(X*X*X*X);
	    scale_add(eX4, R, W, X, R4, w0, W4);
	    if (thread == 0) W -= sum4_(sW);
	}
	else if (X > 25.0) {
	    const TYPE__ (&R_CP)[7] = x20to35::R_CP[thread];
	    const TYPE__ (&R_CR)[3] = x20to35::R_CR[thread];
	    const TYPE__ (&W_CP)[7] = x25to35::W_CP[thread];
	    const TYPE__ (&W_CR)[3] = x25to35::W_CR[thread];
	    evaluate1(X, R, W, R_CP, W_CP);
	    evaluate2(X, R, W, R_CR, W_CR);
	    scale_add(e, R, W, X, R4, w0, W4);
	    if (thread == 0) W -= sum4_(sW);
	}
 	else if (X > 20.0) {
	    const TYPE__ (&R_CP)[7] = x20to35::R_CP[thread];
	    const TYPE__ (&R_CR)[3] = x20to35::R_CR[thread];
	    const TYPE__ (&W_CP)[8] = x20to25::W_CP[thread];
	    const TYPE__ (&W_CR)[3] = x20to25::W_CR[thread];
	    evaluate1(X, R, W, R_CP, W_CP);
	    evaluate2(X, R, W, R_CR, W_CR);
	    scale_add(e, R, W, X, R4, w0, W4);
	    if (thread == 0) W -= sum4_(sW);
	}
	else if (X > 15.0) {
	    TYPE__ y =  X - 17.5;
	    const TYPE__ (&R_CP)[13] = x15to20::R_CP[thread];
	    const TYPE__ (&W_CP)[14] = x15to20::W_CP[thread];
	    const TYPE__ (&W0_CP)[3] = x15to20::W0_CP[thread];
	    evaluate1(y, R, W,  R_CP, W_CP);
	    TYPE__ q = e*evaluate0(X, W0_CP) + w0;
	    if (thread == 0) W = q - sum4_(sW);
	}
 	else if (X > 10.0) {
 	    TYPE__ y =  X - 12.5;
	    const TYPE__ (&R_CP)[13] = x10to15::R_CP[thread];
	    const TYPE__ (&W_CP)[15] = x10to15::W_CP[thread];
	    const TYPE__ (&W0_CP)[4] = x10to15::W0_CP[thread];
	    evaluate1(y, R, W,  R_CP, W_CP);
	    TYPE__ q = e*evaluate0(X, W0_CP) + w0;
	    if (thread == 0) W = q - sum4_(sW);
	}
	else if (X > 5.0) {
	    const TYPE__ (&R_CP)[13] = x5to10::R_CP[thread];
	    const TYPE__ (&W_CP)[16] = x5to10::W_CP[thread];
	    evaluate1(TYPE__(X-7.5), R, W, R_CP, W_CP);
	}
 	else if (X > 1.0) {
	    const TYPE__ (&R_CP)[11] = x1to5::R_CP[thread];
	    const TYPE__ (&W_CP)[16] = x1to5::W_CP[thread];
	    evaluate1(TYPE__(X-3.0), R, W, R_CP, W_CP);
	}
 	else if (X > 3e-7) {
	    const TYPE__ (&R_CP)[8] = x0to1::R_CP[thread];
	    const TYPE__ (&W_CP)[11] = x0to1::W_CP[thread];
	    evaluate1(X, R, W, R_CP, W_CP);
	}
	else {
	    namespace range = x0;
	    const TYPE__ (&C)[2] = range::R_CP[thread];
	    const TYPE__ (&D)[2] = range::W_CP[thread];
	    evaluate1(X, R, W, C, D);
	}

	//change_variable<4>(sR);
	R = R/(1.0 + R);

#undef sum4_
    }


} // namespace roots4


