namespace roots5 {

    static const int N = 5;
    static const TYPE__ PIE4 = 0.785398163397448;

    constant__
    TYPE__ RN[5] = { 0.117581320211778, 1.0745620124369, 3.08593744371754, 6.41472973366203, 11.8071894899717 };
    constant__
    TYPE__ WN[5] = { 1.0, .270967405960535, .0382231610015404, .00151614186862443, 8.62130526143657e-6 };

    namespace x0 {
	constant__
	TYPE__ R_CP[5][2] = {{ 0.0226659266316985, -0.00215865967920897 },
			     { 0.231271692140903, -0.0220258754389745 },
			     { 0.857346024118836, -0.0816520023025515 },
			     { 2.97353038120346, -0.283193369647137 },
			     { 18.4151859759051, -1.75382723579439 }};
	constant__
	TYPE__ W_CP[5][2] = {{ 0.295524224714752, -0.0196867576909777 },
			     { 0.269266719309995, -0.0561737590184721 },
			     { 0.219086362515981, -0.0971152726793658 },
			     { 0.14945134915058, -0.102979262193565 },
			     { 0.0666713443086877, -0.0573782817488315 }};
    }

    namespace x0to1 {
	constant__
	TYPE__ R_CP[5][8] = {{ 0.0226659266316985, -0.00215865967920301, 1.51794097682482E-4, -9.27933625824749E-6, 5.15106194905897E-7, -2.62975022612104E-8, 1.21879111988031E-9, -4.46679165328413E-11 },
			     { 0.231271692140905, -0.0220258754419939, 0.00137506939145643, -6.07268757707381E-5, 1.50716729438474E-6, 2.48339908218932E-8, -4.57267589660699E-9, 1.93117331714174E-10 },
			     { 0.857346024118779, -0.0816520022916145, 0.004033058545972, -7.651163510626E-5, -2.766753852879E-6, 1.31538893944284E-7, 4.84989776180094E-9, 0.0 },
			     { 2.97353038120345, -0.283193369640005, 0.0101210776517279, -7.4601825798763E-7, -4.34482635782585E-6, -2.48581772214623E-7, 0.0, 0.0 },
			     { 18.4151859759049, -1.75382723579114, 0.04596379534985, 1.058229325071E-4, 3.040754680666E-6, 1.77288899268988E-8, -8.92432153868554E-9, 0.0 }};
	constant__
	TYPE__ W_CP[5][11] = {{ 0.295524224714749, -0.0196867576904816, 0.0014912888858679, -1.13218402310546E-4, 8.30316168666696E-6, -5.84914787904823E-7, 3.8911022913381E-8, -2.03822632771791E-9, 0.0, 0.0, 0.0 },
			      { 0.269266719309991, -0.0561737590178812, 0.00938866933338584, -0.00128848868034502, 1.538445806778E-4, -1.646364300836E-5, 1.602894068228E-6, -1.38975551148989E-7, 8.6284811839757E-9, 0.0, 0.0 },
			      { 0.219086362515979, -0.0971152726809059, 0.0260854524809786, -0.00522877807397165, 8.5369767598421E-4, -1.18858834181513E-4, 1.45098401798393E-5, -1.57456991199322E-6, 1.47452251067755E-7, -9.41953204205665E-9, 0.0 },
			      { 0.149451349150573, -0.102979262192227, 0.0379455945268632, -0.00977232537679229, 0.00195682017370967, -3.22542784865557E-4, 4.53160377546073E-5, -5.52351805403748E-6, 5.6659539654447E-7, -3.84961617022042E-8, 0.0 },
			      { 0.0666713443086877, -0.0573782817487958, 0.0250889946832192, -0.00740671222520653, 0.00165695765202643, -2.99102856679638E-4, 4.531969237381E-5, -5.917993920224E-6, 6.743541482689E-7, -6.47097874264417E-8, 4.0959481252143E-9 }};
    }

    namespace x1to5 {
	constant__
	TYPE__ R_CP[5][11] = {{ 0.0173416786387475, -0.00145190025120726, 9.02580687971053E-5, -4.92556826124502E-6, 2.4681069441454E-7, -1.16002134438663E-8, 5.09822003260014E-10, -2.11414838976129E-11, 8.14127461488273E-13, -2.58163897135138E-14, 0.0 },
			      { 0.176055265928744, -0.0152479441718739, 9.12034574793379E-4, -4.23405023015273E-5, 1.43772622028764E-6, -2.35346740649916E-8, -1.104373076913E-9, 1.136643908832E-10, -4.831059411392E-12, 5.44611782010773E-14, 1.04525287289788E-14 },
			      { 0.646432853383057, -0.0597587007636479, 0.00323551502557785, -9.58924580919747E-5, -3.95859409711346E-7, 1.57456141058535E-7, -2.995532064116E-9, -3.390752744265E-10, 1.847170956043E-11, 5.92064260918861E-13, -6.89693150857911E-14 },
			      { 2.21460798080643, -0.223055570487771, 0.00981432631743423, -7.41019244900952E-5, -7.60223407443995E-6, -1.32581997983422E-7, 1.59166632851267E-8, 8.83758848468769E-10, -2.70803518291085E-11, -3.61293809667763E-12, 0.0 },
			      { 13.5704792175847, -1.47486623003693, 0.0470723869619745, 1.37704919387696E-4, 1.50511293969805E-6, -3.03172870136802E-7, -3.496962018025E-8, -2.342817613343E-9, -8.776668218053E-11, 3.16578501501894E-12, 7.12332088345321E-13 }};
	constant__
	TYPE__ W_CP[5][16] = {{ 0.247383140241103, -0.0130892406559521, 8.00338056610995E-4, -5.04404167403568E-5, 3.12338120839468E-6, -1.88329804969573E-7, 1.100758247388E-8, -6.277497362235E-10, 3.485512360993E-11, -1.94147461891055E-12, 1.04348658616398E-13, 0.0, 0.0, 0.0, 0.0, 0.0 },
			      { 0.159834227924213, -0.0229118251223003, 0.00305779768191621, -3.45558237388223E-4, 3.47425221210099E-5, -3.18750295288531E-6, 2.70933462557631E-7, -2.15479017572233E-8, 1.615238462197E-9, -1.146022750992E-10, 7.743219385056E-12, -5.24314473469311E-13, 3.23496149760478E-14, 0.0, 0.0, 0.0 },
			      { 0.0695211812453929, -0.0225514728915673, 0.00493752683045845, -8.37562373221756E-4, 1.18900349101069E-4, -1.46852359124154E-5, 1.616487851917E-6, -1.611749975234E-7, 1.472744068942E-8, -1.244014559219E-9, 9.763932908544E-11, -7.184330797139E-12, 5.26475736681542E-13, -3.42790561802876E-14, 0.0, 0.0 },
			      { 0.0222353727685016, -0.0128290192663141, 0.00416002324339929, -9.68428981886534E-4, 1.78586118867488E-4, -2.74868382777722E-5, 3.64721335274973E-6, -4.26488836563267E-7, 4.46559231067006E-8, -4.23775673047899E-9, 3.679254029085E-10, -2.939403008391E-11, 2.183534866798E-12, -1.60808044529211E-13, 1.04072340345039E-14, 0.0 },
			      { 0.00536963805223095, -0.00437785737450783, 0.00183524565118203, -5.23627942443563E-4, 1.13876001386361E-4, -2.00718990300052E-5, 2.98006900751543E-6, -3.82673275931962E-7, 4.332753856271E-8, -4.389453269417E-9, 4.025371849467E-10, -3.372639523006E-11, 2.596836515749E-12, -1.856950818865E-13, 1.31376515047977E-14, -8.16770412525963E-16 }};
    }

    namespace x5to10 {
	constant__
	TYPE__ R_CP[5][12] = {{ 0.0122703754069176, -8.6800390932374E-4, 4.56547356365536E-5, -2.13775073585629E-6, 9.15858355075147E-8, -3.73782213255083E-9, 1.56666512163407E-10, -4.81561201185876E-12, 1.89737681670375E-13, -1.13825201010775E-14, 0.0, 0.0 },
			      { 0.12259040340369, -0.00914294111576119, 4.90295372978785E-4, -2.20379304598661E-5, 8.20460740637617E-7, -2.42538340602723E-8, 5.464102147892E-10, 1.477175434354E-11, -1.296476623788E-12, 1.27876280158297E-14, -3.67160504428358E-15, 0.0 },
			      { 0.434393683888443, -0.0363329491677178, 0.00200938064965897, -7.94273603184629E-5, 1.71307311000282E-6, 2.87495324207095E-8, -3.6863838563E-9, 1.725627235645E-10, 1.176946020731E-12, -6.9639138542689E-13, 1.39017367502123E-14, 0.0 },
			      { 1.39964149420683, -0.142056749162695, 0.00789092425542937, -2.01087998907735E-4, -4.398596059588E-6, 3.954955671326E-7, 1.106696436509E-8, -1.190574776587E-9, -2.708018219579E-11, 3.753542914426E-12, 1.99910415869821E-14, -1.27815158195209E-14 },
			      { 7.89901551676692, -1.04346091985269, 0.0485221195290753, 2.88711171412814E-6, -2.373394341886E-5, -2.13596683505E-6, -6.2532971387E-8, 5.38116010542E-9, 6.082671496226E-10, 6.861649627426E-12, -2.34074833275956E-12, -1.19442341030461E-13 }};
	constant__
	TYPE__ W_CP[5][17] = {{ 0.201097936411496, -0.00810456360143408, 3.76807779068053E-4, -1.86764236490502E-5, 9.17812870287386E-7, -4.49796778054865E-8, 2.225273630974E-9, -9.535763686605E-11, 4.76124620872E-12, -2.48593096128045E-13, 7.95526040108997E-15, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 },
			      { 0.0971769901268114, -0.00815528438784469, 8.05193921815776E-4, -6.95676245982121E-5, 5.48227244014763E-6, -4.01726946190383E-7, 2.77209637550134E-8, -1.82546185762009E-9, 1.140771033372E-10, -6.830539401049E-12, 3.973252415832E-13, -2.34266248891173E-14, 1.25678686624734E-15, 0.0, 0.0, 0.0, 0.0 },
			      { 0.0225443826852447, -0.00417753183902198, 6.66057194311179E-4, -8.56551787594404E-5, 9.60884622778092E-6, -9.65561998415038E-7, 8.851599803902E-8, -7.503659964159E-9, 5.923946274445E-10, -4.387890955243E-11, 3.058055403795E-12, -2.02286306522E-13, 1.37356038393016E-14, -8.20929494859896E-16, 0.0, 0.0, 0.0 },
			      { 0.00257520532789644, -9.75935943447037E-4, 2.41722511389146E-4, -4.53759748787756E-5, 7.02338477986218E-6, -9.33687124875935E-7, 1.09415155268932E-7, -1.15042731790748E-8, 1.099047050624E-9, -9.632707991704E-11, 7.805245193391E-12, -5.881379088074E-13, 4.127368817265E-14, -2.730195628655E-15, 1.85299909689937E-16, -1.0876461248879E-17, 0.0 },
			      { 1.75013126731224E-4, -1.2111378215037E-4, 4.52254031046244E-5, -1.18023950002105E-5, 2.3903912613814E-6, -3.97500114084351E-7, 5.62222859033624E-8, -6.92956101109829E-9, 7.57553198166848E-10, -7.4456006997494E-11, 6.64976446790959E-12, -5.44436631413933E-13, 4.114588668138E-14, -2.876728287383E-15, 1.886145834486E-16, -1.26518146195173E-17, 7.28996979748849E-19 }};
    }

    namespace x10to15 {
	constant__
	TYPE__ R_CP[5][13] = {{ 0.00885218988709735, -5.35185183652937E-4, 2.38589932752937E-5, -9.35118186333939E-7, 3.997777641049E-8, -1.033307012866E-9, 2.301379846544E-11, -4.154857548139E-12, 3.660484641252E-14, 1.395993802064E-14, 7.2087299737386E-16, -4.16387977337393E-17, 0.0 },
			      { 0.0868245143991948, -0.00554735977651677, 2.57987709704822E-4, -1.02384302866534E-5, 4.24034019462E-7, -9.77283189131E-9, 9.561341254948E-11, -3.538906780633E-11, 8.964205979517E-14, 1.737896339191E-13, 6.24941647247927E-15, -4.56279214732217E-16, 0.0 },
			      { 0.294150684465425, -0.0213014521653498, 0.00108648982748911, -4.39602147345028E-5, 1.643290788086E-6, -2.217064940373E-8, -1.333480437968E-9, -5.814101544957E-11, -9.02339815951E-13, 7.884307667104E-13, 2.13925810087833E-14, -2.52879337929239E-15, 0.0 },
			      { 0.860057928514554, -0.0791197893350253, 0.00473264487389288, -1.88893338587047E-4, 4.520749076914E-6, 1.543764346501E-7, -2.007890743962E-8, -1.106601744067E-10, 5.214153461337E-11, 8.960828117859E-13, 5.37848223438815E-15, -6.42391438038888E-15, 0.0 },
			      { 3.87328263873381, -0.576800927133412, 0.0423367010370921, -9.56275105032191E-4, -5.72877569731162E-5, 1.34240904266268E-6, 2.58604071603561E-7, -2.05603889396319E-9, -1.22398388308E-9, -3.045253104617E-12, 5.587369053655E-12, 4.87224967526081E-14, -2.24366166957225E-14 }};
	constant__
	TYPE__ W_CP[5][16] = {{ 0.168122596736809, -0.00538533819142287, 1.94218051498662E-4, -7.51821178144509E-6, 3.42197444235714E-7, -9.65094802088511E-9, 3.911507312679E-10, -4.234204823846E-11, 5.851494250405E-14, 7.25673623859497E-14, 8.98007931950169E-15, 0.0, 0.0, 0.0, 0.0, 0.0 },
			      { 0.0703302497508176, -0.0034618826533835, 2.57820531617185E-4, -1.73148206795827E-5, 1.046236652393E-6, -6.389171736029E-8, 3.533277061402E-9, -1.720997242621E-10, 1.003849567976E-11, -5.500330153548E-13, 1.96855386549388E-14, -1.05490525395105E-15, 0.0, 0.0, 0.0, 0.0 },
			      { 0.0115543698537013, -0.00105539461930597, 1.26928442448148E-4, -1.20490761741576E-5, 1.01503783870262E-6, -8.23540111024147E-8, 6.0418906330361E-9, -4.08688551136506E-10, 2.768503957853E-11, -1.749051512721E-12, 9.945311467434E-14, -6.24245825017148E-15, 3.60020423754545E-16, 0.0, 0.0, 0.0 },
			      { 6.45524336158384E-4, -1.19434130620929E-4, 2.12937256719543E-5, -2.92658670674908E-6, 3.49164261987184E-7, -3.75484943783021E-8, 3.63722952167779E-9, -3.23322654638336E-10, 2.67958697789258E-11, -2.06638666222265E-12, 1.491302084832E-13, -1.016528519495E-14, 6.557620865832E-16, -4.31723745510697E-17, 2.51163533058925E-18, 0.0 },
			      { 9.94307982432868E-6, -4.30868944351523E-6, 1.24621276265907E-6, -2.66924538268397E-7, 4.64460857084983E-8, -6.84655877575364E-9, 8.77489010276305E-10, -9.96995451348129E-11, 1.018245804339E-11, -9.446196472547E-13, 8.031304476153E-14, -6.301348858104E-15, 4.570804313173E-16, -3.107631557965E-17, 2.16234952241296E-18, -1.29043630202811E-19 }};
    }

    namespace x15to20 {
	constant__
	TYPE__ R_CP[5][13] = {{ 0.00667768703938812, -3.49912254976317E-4, 1.45418822817771E-5, -3.99851421361031E-7, 1.231203269887E-8, -1.123776903884E-9, 3.357056136731E-11, 4.275180095653E-12, -1.186752035569E-13, -3.260875931644E-14, 7.8357401095707E-16, 1.9187576454574E-16, 0.0 },
			      { 0.0644912219301603, -0.00355524254280266, 1.54942754358273E-4, -4.47788241748377E-6, 1.347873288827E-7, -1.184607130107E-8, 3.853670706486E-10, 4.527419140333E-11, -1.615655871159E-12, -3.385363492036E-13, 1.01640716785099E-14, 2.02778478673555E-15, 0.0 },
			      { 0.210244289044705, -0.0130102750145071, 6.31405161185185E-4, -2.03797212506691E-5, 5.863956443581E-7, -4.60355944901E-8, 1.766397336977E-9, 1.814709816693E-10, -1.020720636353E-11, -1.249779730869E-12, 6.00464406395001E-14, 7.79850771456444E-15, 0.0 },
			      { 0.562170709585029, -0.0435712368303551, 0.00259924221372643, -1.02790452049013E-4, 2.74941013315834E-6, -1.44374545515769E-7, 6.88409355245582E-9, 7.19101516047753E-10, -7.484522135512E-11, -3.217227223463E-12, 4.85944766585E-13, 1.94152129078465E-14, -2.92397030777912E-15 },
			      { 1.89999883453047, -0.245653725061323, 0.0229121951862538, -0.00133684303917681, 2.5003215442164E-5, 2.69463269394888E-6, -1.81502268782664E-7, -4.98680128123353E-9, 9.492190032313E-10, -7.755793199043E-12, -3.89274162228E-12, 1.24156229350669E-13, 1.1797612684006E-14 }};
	constant__
	TYPE__ W_CP[5][15] = {{ 0.145298342081522, -0.00386293751153466, 1.21958354908768E-4, -2.86605475073259E-6, 1.132736008979E-7, -1.014517563435E-8, 1.461418533652E-10, 3.8535969354E-11, 2.021279817961E-13, -3.000659497257E-13, -6.95671892641256E-16, 1.74841995087592E-15, 0.0, 0.0, 0.0 },
			      { 0.057800991453663, -0.00180677298502757, 1.00104454489518E-4, -6.12300038720919E-6, 2.907862965346E-7, -1.00914787975E-8, 6.161037256669E-10, -5.341838883262E-11, 1.275068098526E-12, 1.220613939709E-13, 1.85007587796671E-15, -1.11199320525573E-15, 0.0, 0.0, 0.0 },
			      { 0.00839213709428516, -3.58426847857878E-4, 3.38028206156144E-5, -2.96075397351101E-6, 1.791418482685E-7, -8.799518866802E-9, 6.638043374114E-10, -5.400548574357E-11, 1.98379995015E-12, 2.606163540537E-15, 6.67922080354234E-15, -9.49816486853687E-16, 0.0, 0.0, 0.0 },
			      { 3.54846978585226E-4, -2.43236345136782E-5, 3.4634020459387E-6, -3.90387662925193E-7, 3.2776171442296E-8, -2.52746574206884E-9, 2.15219425727959E-10, -1.70859789556117E-11, 1.049256040808E-12, -6.033814209875E-14, 4.745009557656E-15, -3.4484187784414E-16, 1.3382997106018E-17, 0.0, 0.0 },
			      { 2.43682618601E-6, -3.59858901591047E-7, 7.72165684563049E-8, -1.23621614171556E-8, 1.62012436344069E-9, -1.92566242323525E-10, 2.11630022068394E-11, -2.09498886675861E-12, 1.87305099552692E-13, -1.56872999797549E-14, 1.246599177672E-15, -9.069722758289E-17, 6.030500065438E-18, -4.24837886165685E-19, 2.69412277020887E-20 }};
    }

    namespace x20to25 {
	constant__
	TYPE__ R_CP[5][12] = {{ 0.00524663913001114, -2.30896753853196E-4, 9.46859114120901E-6, -3.03763737404491E-7, 3.56242145897468E-9, 2.17264723874381E-10, 5.823521627177E-12, -2.676703245252E-12, 1.445982921243E-13, 7.39404133595713E-15, -1.13927848238726E-15, 0.0 },
			      { 0.0500845183695073, -0.00230092118015697, 9.84635072633776E-5, -3.32380270861364E-6, 4.616160236414E-8, 2.216486288382E-9, 3.70991379065E-11, -2.729713905266E-11, 1.64984659123E-12, 6.1840650972E-14, -1.22296292045864E-14, 2.89872355524581E-16 },
			      { 0.158689469640791, -0.00803133015084373, 3.78290946669264E-4, -1.42982334217081E-5, 2.699970652707E-7, 7.534109114453E-9, -8.295965491209E-11, -9.635646767455E-11, 7.546203883874E-12, 1.136466605916E-13, -4.894192706268E-14, 1.97068646590923E-15 },
			      { 0.397847167557815, -0.0242051126993146, 0.00136795464918785, -6.37524802411383E-5, 1.851491550417E-6, 7.323046997451E-9, -2.070575894402E-9, -2.075594313618E-10, 3.209520801187E-11, -7.522712577474E-13, -1.55850612605745E-13, 1.33642069941389E-14 },
			      { 1.09857804755042, -0.0993122509049447, 0.00829382168612791, -5.94805357558251E-4, 3.292234974141E-5, -1.068175391334E-6, -1.835675889421E-8, 4.804518986559E-9, -2.632066100073E-10, -4.286617818951E-13, 1.04447493138843E-12, -6.07053986130526E-14 }};
	constant__
	TYPE__ W_CP[5][14] = {{ 0.128718310443295, -0.00282718629312875, 8.65797782880311E-5, -2.19427111221848E-6, 9.20072040917242E-9, 1.52314028857627E-9, 1.479321506529E-10, -2.547619474232E-11, 7.817349237071E-13, 1.00438927627833E-13, -9.10338640266542E-15, 0.0, 0.0, 0.0 },
			      { 0.0506607252890186, -0.00114423444576221, 4.23605032368922E-5, -2.11919643127927E-6, 1.22477891136278E-7, -5.68108973828949E-9, 9.229645304956E-11, 8.261326648131E-12, -2.358734508092E-13, -6.43424400204124E-14, 5.5238092761876E-15, 0.0, 0.0, 0.0 },
			      { 0.00716639814253567, -1.72559275066834E-4, 8.84176371665149E-6, -7.40736211041247E-7, 6.07453633298986E-8, -3.36086411698418E-9, 6.705582751532E-11, 4.214670817758E-12, -4.157593182747E-14, -5.11826702824182E-14, 3.99457454087556E-15, 0.0, 0.0, 0.0 },
			      { 2.85954806605017E-4, -7.80555094280483E-6, 6.04993294708874E-7, -7.03520999708859E-8, 6.773680559084E-9, -4.42671979311163E-10, 1.67070784862985E-11, -3.3955416364974E-13, 4.826636065733E-14, -8.526651626939E-15, 6.126212599772E-16, -2.45525846412281E-18, -2.14649508112234E-18, 0.0 },
			      { 1.65186146094969E-6, -5.9776741740054E-8, 7.80430641995926E-9, -1.17842611094141E-9, 1.36296870441445E-10, -1.18527596836592E-11, 8.441808227634E-13, -6.117895297439E-14, 5.386312669975E-15, -4.810285046442E-16, 3.357639744582E-17, -1.586937691507E-18, 6.92182516324628E-20, -5.63938733073804E-21 }};
    }


    namespace x25to40 {
	constant__
	TYPE__ R_CP[5][9] = {{ -407186.366852475, 120662.887111273, -15207.3917378512, 1062.51216612604, -44.7216460864586, 1.13467897349442, -0.0159437614121125, 1.19921331441483E-4, -1.73363958895356E-6 },
			     { -3511907.92816119, 1061075.7703834, -135888.06983827, 9626.04416506819, -410.468817024806, 10.5563640866077, -0.150043662589017, 0.00110331262112395, -1.6010254262171E-5 },
			     { -7163415.68174085, 2348796.93563358, -319504.627257548, 23698.5942687423, -1048.91729356965, 27.8360021977405, -0.401048115525954, 0.00269025112122177, -4.48880032128422E-5 },
			     { 10248975.964541, -1776389.56809518, 95952.9683876419, 281.839578728845, -232.077034386717, 9.12692349152792, -0.0765735935499627, -0.00229263585792626, -6.38526371092582E-5 },
			     { -16119645.5032613, 2222155.28319857, -40729.7627297272, -11600.3199605875, 1058.04526830637, -45.6752462103909, 1.12594870794668, -0.0225963977930044, -3.59049364231569E-5 }};
	constant__
	// coefficient [0][0] is negative in original code, but the value does not seem to matter
	TYPE__ W_CP[5][10] = {{ -0.01962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 },
			      { 3106386.27744347, -892528.122219324, 110255.055017664, -7657.22701219557, 328.062687293374, -8.96743743396132, 0.161077633475573, -0.0022283501765589, 2.7777834587065E-5, 0.0 },
			      { 2264108.96607237, -655181.056671474, 81450.7604229357, -5688.32664556359, 244.789386487321, -6.69649981309161, 0.118520453711586, -0.00154837969489927, 1.83574464457207E-5, 0.0 },
			      { 596854.758661427, -181852.473229081, 24294.5528916947, -1869.71865249111, 91.514235699633, -2.96135703135647, 0.0637686375770059, -9.04491430884113E-4, 8.12621667601546E-6, -2.4079943580995E-8 },
			      { 9715.75094154768, -3022.60070158372, 412.007318109157, -32.3248143316007, 1.61156533367153, -0.0530573476742071, 0.00115791154612838, -1.6396091543108E-5, 1.43069932644286E-7, -4.6110090613397E-10 }};
    }

    namespace x40to59 {
	constant__
	TYPE__ R_CP[5][4] = {{ 714.16008865547, -64.5964225381113, 2.07301567989771, -0.0243758528330205 },
			     { 6618.44165304871, -599.774730340912, 19.3190784733691, -0.228861955413636 },
			     { 19536.6082947811, -1777.0414322552, 57.6874090316016, -0.695053039285586 },
			     { 42302.482812142, -3866.8735091428, 127.050801091948, -1.58072809087018 },
			     { 82196.681659569, -7577.28527654961, 251.830424600204, -3.33963830405396 }};
	constant__
	TYPE__ W_CP[5][4] = {{ 0.0, 0.0, 0.0, 0.0 },
			     { 0.00668743788585688, -6.87646614786982E-4, 2.09539509123135E-5, 0.0 },
			     { 0.00387706687610809, -4.19389884772726E-4, 1.34547929260279E-5, 0.0 },
			     { 3.03274662192286E-4, -3.5522456427559E-5, 1.23464092261605E-6, 0.0 },
			     { 2.41522703684296E-6, -3.27722199212781E-7, 1.35482430510942E-8, 0.0 }};
    }


    BOOST_GPU_ENABLED
    inline void evaluate(TYPE__ X, TYPE__ (&R)[5], TYPE__ (&W)[5]) {

	if (X > 25.0) {
	    TYPE__ w0 = sqrt(PIE4/X);
	    if (X > 59.0) {
		divide(R, X, RN);
		scale(W, w0, WN);
		W[0] -= sum<N-1>(&W[1]);
		return;
	    }

	    TYPE__ e = exp(-X);
	    if (X > 40.0) {
		using namespace x40to59;
		TYPE__ X3 = X*X*X;
		TYPE__ eX3 = X3*e;
		polynomial::evaluate2(X, R, W, R_CP, W_CP);
		scale_add(eX3, R, eX3*X3, W, X, RN, w0, WN);
	    }
	    else {
		using namespace x25to40;
		polynomial::evaluate2(X, R, W, R_CP, W_CP);
		scale_add(e, R, W, X, RN, w0, WN);
	    }
	    W[0] -= sum<N-1>(&W[1]);
	}
	else if (X > 20.0) {
	    using namespace x20to25;
	    TYPE__ y = X - 22.5;
	    polynomial::evaluate2(y, R, W, R_CP, W_CP);
	}
	else if(X > 15.0) {
	    using namespace x15to20;
	    TYPE__ y =  X - 17.5;
	    polynomial::evaluate2(y, R, W, R_CP, W_CP);
	}
	else if(X > 10.0) {
	    using namespace x10to15;
	    TYPE__ y =  X - 12.5;
	    polynomial::evaluate2(y, R, W, R_CP, W_CP);
	}
	else if(X > 5.0) {
	    TYPE__ y = X - 7.5;
	    using namespace x5to10;
	    polynomial::evaluate2(y, R, W, R_CP, W_CP);
	}
	else if(X > 1.0) {
	    TYPE__ y = X - 3.0;
	    using namespace x1to5;
	    polynomial::evaluate2(y, R, W, R_CP, W_CP);
	}
	else if(X > 3e-7) {
	    using namespace x0to1;
	    polynomial::evaluate2(X, R, W, R_CP, W_CP);
	}
	else {
	    using namespace x0;
	    polynomial::evaluate2(X, R, W, R_CP, W_CP);
	}

	change_variable<N>(R);

    }

    BOOST_GPU_ENABLED
    inline void evaluate(TYPE__ X, TYPE__ *sR, TYPE__ *sW,
			 const unsigned short &thread) {

	if (thread >= N) return;

	const TYPE__ &RN = roots5::RN[thread];
	const TYPE__ &WN = roots5::WN[thread];

	TYPE__ &R = sR[thread];
	TYPE__ &W = sW[thread];

	if (X > 25.0) {
	    TYPE__ w0 = sqrt(PIE4/X);
	    if (X > 59.0) {
		divide(R, X, RN);
		scale(W, w0, WN);
		if (thread == 0) sW[0] -= sum<N-1>(&sW[1]);
		return;
	    }

	    TYPE__ e = exp(-X);
	    if (X > 40.0) {
		const TYPE__ (&R_CP)[4] = x40to59::R_CP[thread];
		const TYPE__ (&W_CP)[4] = x40to59::W_CP[thread];
		const TYPE__ X3 = X*X*X;
		const TYPE__ eX3 = X3*e;
		evaluate1(X, R, W, R_CP, W_CP);
		scale_add(eX3, R, eX3*X3, W, X, RN, w0, WN);
	    }
	    else {
		const TYPE__ (&R_CP)[9] = x25to40::R_CP[thread];
		const TYPE__ (&W_CP)[10] = x25to40::W_CP[thread];
		evaluate1(X, R, W, R_CP, W_CP);
		scale_add(e, R, W, X, RN, w0, WN);
	    }
	    if (thread == 0) sW[0] -= sum<N-1>(&sW[1]);
	}
	else if (X > 20.0) {
	    const TYPE__ (&R_CP)[12] = x20to25::R_CP[thread];
	    const TYPE__ (&W_CP)[14] = x20to25::W_CP[thread];
	    TYPE__ y = X - 22.5;
	    evaluate1(y, R, W, R_CP, W_CP);
	}
	else if(X > 15.0) {
	    const TYPE__ (&R_CP)[13] = x15to20::R_CP[thread];
	    const TYPE__ (&W_CP)[15] = x15to20::W_CP[thread];
	    TYPE__ y =  X - 17.5;
	    evaluate1(y, R, W, R_CP, W_CP);
	}
	else if(X > 10.0) {
	    const TYPE__ (&R_CP)[13] = x10to15::R_CP[thread];
	    const TYPE__ (&W_CP)[16] = x10to15::W_CP[thread];
	    TYPE__ y =  X - 12.5;
	    evaluate1(y, R, W, R_CP, W_CP);
	}
	else if(X > 5.0) {
	    const TYPE__ (&R_CP)[12] = x5to10::R_CP[thread];
	    const TYPE__ (&W_CP)[17] = x5to10::W_CP[thread];
	    TYPE__ y = X - 7.5;
	    evaluate1(y, R, W, R_CP, W_CP);
	}
	else if(X > 1.0) {
	    const TYPE__ (&R_CP)[11] = x1to5::R_CP[thread];
	    const TYPE__ (&W_CP)[16] = x1to5::W_CP[thread];
	    TYPE__ y = X - 3.0;
	    evaluate1(y, R, W, R_CP, W_CP);
	}
	else if(X > 3e-7) {
	    const TYPE__ (&R_CP)[8] = x0to1::R_CP[thread];
	    const TYPE__ (&W_CP)[11] = x0to1::W_CP[thread];
	    evaluate1(X, R, W, R_CP, W_CP);
	}
	else {
	    const TYPE__ (&R_CP)[2] = x0::R_CP[thread];
	    const TYPE__ (&W_CP)[2] = x0::W_CP[thread];
	    evaluate1(X, R, W, R_CP, W_CP);
	}

	change_variable(R);
    }

} // namespace roots5

