C 17 Feb 12 - MWS - assume this will be used on Unix only (remove *UNX).
C  2 DEC 02 - MWS - RDCART: COUNT ATOMS CORRECTLY EVEN IF NO BLANK LINE
C 28 MAY 94 - MWS - USE PROPER ROTATION IN PRAXIS
C 17 JUN 92 - MWS - MAKE SURE THIS PROGRAM RUNS SERIALLY
C 14 MAY 92 - JHJ - CAN PUT IN TWO GEOMETRIES AND CALCULATE THE MASS-
C                   WEIGHTED ARC DISTANCE W/ & W/O PRINCIPAL AXES.
C  3 JAN 92 - MWS - MOLPLT SHOULDN'T BOND ATOMS IF CARTESIANS READ
C 25 NOV 91 - MWS - FIX BUG LIMITING Z=54, BETTER ERROR HANDLING
C 19 NOV 91 - JHJ - ADD OPTION TO READ BOHRS RATHER THAN ANGSTROMS
C 16 OCT 91 - JHJ - PUNCH OUT CHEM3D+ INPUT FILE.
C  9 JAN 91 - MWS - FIX AXIS PERMUTATION OPTION
C  7 NOV 90 - MWS - ERROR MESSAGE IF STRINGS DON'T GET DEFINED.
C  5 NOV 90 - STE - MAKE MINIMUM CHARACTER LENGTH 4
C 17 OCT 90 - JHJ - BUG FIXED IN RDMPC
C  8 OCT 90 - MK  - ATOM NAMES AND THEIR CONNECTIONS GENERALIZED
C                   TO FULL GAUSSIAN STYLE (STRING/INTEGER MIX)
C  3 OCT 90 - JHJ - ADD OPTION TO READ IN MOPAC STYLE Z-MATRIX
C 23 SEP 90 - NM  - MOLPLT INPUT FILE SUBROUTINE ADDED
C 14 SEP 90 - JHJ - ADD OPTION TO REARRANGE AXIS
C 13 SEP 90 - JHJ - MBLDR SWALLOWS G86 INPUT FILE, NUMERIC
C                   OR SYMBOLIC. OPTIONS CAN REPLACE # CARD.
C 22 SEP 89 - MWS - CHANGE ANGSTROMS-BOHR CONVERSION FACTOR
C  8 APR 89 - MWS - INCORPORATE IBM,VAX,UNIX OPEN STATEMENTS.
C 29 MAR 86 - MWS - CHANGE COORD OUTPUT TO MATCH GAMESS
C 11 AUG 85 - MWS - EXTEND MASS TABLE TO XENON
C 26 APR 85 - MWS - PUT UP ON VAX, FIXING CARTESIAN OPTION
C 27 JAN 85 - MWS - CORRECT MOMENTS OF INERTIA COMPUTED
C  8 JUN 84 - JAB - ADD CARTESIAN COORD OPTION
C  2 MAY 84 - MWS - PUT UP ON IBM PC
C
C     * * * * MODEL BUILDER * * * *
C     ORIGINALLY WRITTEN AT CARNEGIE-MELLON A LONG TIME AGO
C     AUTHOR - Mark S. Gordon and John A. Pople
C              QCPE program 135
C              J.Am.Chem.Soc. 89, 4253 (1967).
C
C     This program must be linked to GAMESS file FRFMT.SRC,
C     so use FORTRAN 32 or 64 bit options just as you used
C     when compiling GAMESS!
C
C     cd /u1/mike/gamess/tools
C     
C     gfortran -fdefault-integer-8 -O2 -std=legacy \
C                              -o mbldr.x mbldr.f ../object/frfmt.o
C     ifort -i8 -O2            -o mbldr.x mbldr.f ../object/frfmt.o
C     xlf -qintsize=8 -q64 -O2 -o mbldr.x mbldr.f ../object/frfmt.o
C     g77 -O2                  -o mbldr.x mbldr.f ../object/frfmt.o
C
C*PROGRAM MBLDR *DECK MBLDR
      PROGRAM MBLDR
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      LOGICAL CART, MOPAC, SDIST, SSAVE, DOPRIN
      LOGICAL GOPARR,DSKWRK,MASWRK
      PARAMETER (MXATM=500, MXAT2=(MXATM*MXATM+MXATM)/2, MAXZ=104)
      CHARACTER*4  POUND,ATM,WORD,STRIP
      CHARACTER*4  AXIS(3),AXES(3),ATMLAB(MAXZ+2)
      CHARACTER*8  TITL,BLANK,VAR
      CHARACTER*8  BL2(MXATM),ALPHA2(MXATM),BETA2(MXATM)
      CHARACTER*80 TITLE
      CHARACTER*100 FILENM
      DIMENSION DSTNCE(MXAT2),AMASS(MAXZ+2),NEG(MXATM,3),
     *          BL(MXATM),ALPHA(MXATM),BETA(MXATM),A(MXATM),
     *          IZ(MXATM,4),B(MXATM),D(MXATM),IATNO(MXATM),
     *          V1(3),V2(3),V3(3),VP(3),VJ(3),
     *          AL1(3),AL2(3),AL3(3),AL4(3),COLD(MXATM,3)
      COMMON /INFO  / C(MXATM,3),ATM(MXATM),IAN(MXATM),NATOMS
      COMMON /PAR   / ME,MASTER,NPROC,IBTYP,IPTIM,GOPARR,DSKWRK,MASWRK
      DATA AXES/'X   ','Y   ','Z   '/
      DATA TITL/'DISTANCE'/
      DATA BLANK/'        '/
C
C        NOTE THAT THE SYMBOL TABLE AND THE MASS TABLE
C        HAVE TWO DUMMY ATOMS AFTER THE -MAXZ- TRUE ATOMS.
C
      DATA ATMLAB/'H   ','HE  ','LI  ','BE  ','B   ','C   ',
     *            'N   ','O   ','F   ','NE  ','NA  ','MG  ',
     *            'AL  ','SI  ','P   ','S   ','CL  ','AR  ',
     *            'K   ','CA  ','SC  ','TI  ','V   ','CR  ',
     *            'MN  ','FE  ','CO  ','NI  ','CU  ','ZN  ',
     *            'GA  ','GE  ','AS  ','SE  ','BR  ','KR  ',
     *            'RB  ','SR  ','Y   ','ZR  ','NB  ','MO  ',
     *            'TC  ','RU  ','RH  ','PD  ','AG  ','CD  ',
     *            'IN  ','SN  ','SB  ','TE  ','I   ','XE  ',
     *            'CS  ','BA  ','LA  ','CE  ','PR  ','ND  ',
     *            'PM  ','SM  ','EU  ','GD  ','TB  ','DY  ',
     *            'HO  ','ER  ','TM  ','YB  ','LU  ','HF  ',
     *            'TA  ','W   ','RE  ','OS  ','IR  ','PT  ',
     *            'AU  ','HG  ','TL  ','PB  ','BI  ','PO  ',
     *            'AT  ','RN  ','FR  ','RA  ','AC  ','TH  ',
     *            'PA  ','U   ','NP  ','PU  ','AM  ','CM  ',
     *            'BK  ','CF  ','ES  ','FM  ','MD  ','NO  ',
     *            'LR  ','RF  ','X   ','BQ  '/
C                     MASS OF MOST ABUNDANT ISOTOPE, UP TO LR
      DATA (AMASS(I),I=1,54)  /
     *   1.007825D+00,4.0026D+00,7.01600D+00,9.01218D+00,11.00931D+00,
     *   12.0D+00,14.00307D+00,15.99491D+00,18.99840D+00,19.99244D+00,
     *   22.9898D+00,23.98504D+00,26.98153D+00,27.97693D+00,
     *   30.97376D+00,31.97207D+00,34.96885D+00,39.948D+00,
     *   38.96371D+00,39.96259D+00,44.95592D+00,47.90D+00,50.9440D+00,
     *   51.9405D+00,54.9381D+00,55.9349D+00,58.9332D+00,57.9353D+00,
     *   62.9298D+00,63.9291D+00,68.9257D+00,73.9219D+00,74.9216D+00,
     *   79.9165D+00,78.9183D+00,83.9115D+00,
     *   84.9117D+00,87.9056D+00,89.9054D+00,89.9043D+00,92.9060D+00,
     *   97.9055D+00,97.0D+00,101.9037D+00,102.9048D+00,105.9032D+00,
     *   106.9041D+00,113.9036D+00,114.9041D+00,119.9022D+00,
     *   120.9038D+00,129.9067D+00,126.9044D+00,131.9042D+00/
      DATA (AMASS(I),I=55,MAXZ)  /
     *   132.9054D+00,137.9052D+00,138.9063D+00,139.9054D+00,
     *   140.9076D+00,141.9077D+00,144.9127D+00,151.9197D+00,
     *   152.9212D+00,157.9241D+00,158.9253D+00,163.9292D+00,
     *   164.9303D+00,165.9303D+00,168.9342D+00,173.9389D+00,
     *   174.9408D+00,179.9465D+00,180.9480D+00,183.9509D+00,
     *   186.9557D+00,191.9615D+00,192.9629D+00,194.9648D+00,
     *   196.9665D+00,201.9706D+00,
     *   204.9744D+00,207.9766D+00,208.9804D+00,208.9824D+00,
     *   209.9871D+00,222.0176D+00,
     *   223.0197D+00,226.0254D+00,
     *   227.0278D+00,232.0381D+00,231.0359D+00,238.0508D+00,
     *   237.0482D+00,244.0642D+00,243.0614D+00,247.0703D+00,
     *   247.0703D+00,251.0796D+00,252.0829D+00,257.0751D+00,
     *   258.0986D+00,259.1009D+00,260.1053D+00,261.1087D+00/
      DATA (AMASS(I),I=MAXZ+1,MAXZ+2) /2*0.0D+00/
C
      DATA TOANGS/0.52917724924D+00/
      DATA ZERO,ONE,TWO,TM5/0.0D+00,1.0D+00,2.0D+00,1.0D-05/
      DATA PI/3.14159265359D+00/ , ONE80/180.0D+00/
      DATA BADVAL/1234.56578D+09/
C
C           THIS PROGRAM RUNS IN SEQUENTIAL MODE,
C
      ME = 0
      MASTER = 0
      NPROC = 1
      MASWRK = ME.EQ.MASTER
      DSKWRK = .FALSE.
C
C           OPEN INPUT DISK FILE IR, AND OUTPUT FILE IW
C
      IR=1
      IW=6
C
*VMS  OPEN (UNIT=IR,FILE='MBLDR',STATUS='OLD',
*VMS *      FORM='FORMATTED',ACCESS='SEQUENTIAL')
*VMS  OPEN (UNIT=IW, STATUS='NEW', FORM='FORMATTED',
*VMS *      ACCESS='SEQUENTIAL', CARRIAGECONTROL='LIST')
C
*IBM  OPEN (UNIT=IR,FILE='MBLDR',STATUS='OLD',
*IBM *      FORM='FORMATTED',ACCESS='SEQUENTIAL')
C
      CALL GETENV('MBLDR',FILENM)
      IF(FILENM(1:1).EQ.' ') THEN
            WRITE(IW,*) 'YOU MUST ASSIGN MBLDR TO YOUR INPUT FILE BY A'
            WRITE(IW,*) '   SETENV MBLDR INPUT_FILE_NAME'
            STOP
         END IF
      OPEN(UNIT=IR, FILE=FILENM, STATUS='OLD', FORM='FORMATTED',
     *           ACCESS='SEQUENTIAL')
C
C               OPEN THE FREE FORMAT SCANNER
C
      CALL OPNCRD(IR,-IW)
      WRITE(IW,9000)
C
      SSAVE=.FALSE.
   50 CONTINUE
C
      DO 110 I=1,MXATM
         BL(I)    = BADVAL
         ALPHA(I) = BADVAL
         BETA(I)  = BADVAL
         BL2(I)   = BLANK
         ALPHA2(I)= BLANK
         BETA2(I) = BLANK
         C(I,1)=ZERO
         C(I,2)=ZERO
         C(I,3)=ZERO
  110 CONTINUE
C
C            READ OPTIONS CARD, PROVIDE DEFAULTS FOR ALL OPTIONS
C
      CALL RDCARD('MBLDR 1 ',IEOF)
      NX=1
      NY=2
      NZ=3
      CART  = .FALSE.
      MOPAC = .FALSE.
      UNITS = ONE
      SDIST = .FALSE.
      DOPRIN = .TRUE.
C
C            FIRST LINE MIGHT BE A POUND CARD TO BE IGNORED...
C
      CALL GSTRNG(POUND,-1)
      IF(POUND(1:1).EQ.'#') GO TO 200
C
C            OR IT MIGHT CONTAIN TRUE OPTIONS TO BE SCANNED OFF
C
      CALL REREAD
  120 CONTINUE
      CALL GSTRNG(WORD,-4)
      IF(WORD.EQ.'    ') GO TO 200
C
C            AXIS(AXES) OPTION PERMITS PERMUTATION OF PRINCIPAL AXES.
C
      IF(WORD.EQ.'AXIS'  .OR.  WORD.EQ.'AXES') THEN
         NX=0
         NY=0
         NZ=0
         CALL GSTRNG(AXIS(1),-4)
         CALL GSTRNG(AXIS(2),-4)
         CALL GSTRNG(AXIS(3),-4)
         DO 140 I=1,3
            IF(AXIS(I).EQ.AXES(1)) NX=I
            IF(AXIS(I).EQ.AXES(2)) NY=I
            IF(AXIS(I).EQ.AXES(3)) NZ=I
  140    CONTINUE
         IF((NX+NY+NZ).NE.6) STOP 'ERROR READING AXIS PERMUTATION'
         GO TO 120
      END IF
C
C            CART OPTION READS CARTESIANS RATHER THAN Z-MATRIX
C
      IF(WORD.EQ.'CART') THEN
         CART = .TRUE.
         GO TO 120
      END IF
C
      IF(WORD.EQ.'MOPA') THEN
         MOPAC = .TRUE.
         GO TO 120
      END IF
C
C            AS THE MOLECULE IS READ, BOHRS WILL BE AUTOMATICALLY
C            CONVERTED INTO ANGSTROMS SO THE REST OF THE PROGRAM
C            WILL KNOW FOR SURE THAT IS WHAT IT HAS.
C
      IF(WORD.EQ.'BOHR') THEN
         UNITS=TOANGS
         GO TO 120
      END IF
C
      IF(WORD.EQ.'SDIS') THEN
         SDIST = .TRUE.
         GO TO 120
      END IF
C
      IF(WORD.EQ.'NOPR') THEN
         DOPRIN = .FALSE.
         GO TO 120
      END IF
C
      WRITE(IW,*) 'UNRECOGNIZED OPTION=',WORD
      STOP
C
C         FINISHED READING OPTION CARD.  SKIP OVER A BLANK CARD,
C         READ THE TITLE CARD, THEN SKIP ANOTHER BLANK CARD.
C
  200 CONTINUE
      CALL RDCARD('MBLDR 2 ',IEOF)
      CALL RDCARD('MBLDR 3 ',IEOF)
      CALL GSTRNG(TITLE,80)
      WRITE(IW,9010) TITLE
      CALL RDCARD('MBLDR 4 ',IEOF)
C
C         READ CHARGE/MULTIPLICITY CARD
C
      CALL RDCARD('MBLDR 5 ',IEOF)
      ICH = IFIND('CHARGE  ',IERR)
      MUL = IFIND('MULTIP  ',IERR)
C
C         OPTIONALLY, READ IN CARTESIANS INSTEAD OF Z-MATRIX
C
      IF(CART) THEN
         CALL RDCART(UNITS,IR,NRATM)
         NATOMS=NRATM
         M=NRATM
         GO TO 700
      END IF
C
C         START READING OF EITHER SORT OF Z-MATRIX
C           NRATM = NUMBER OF REAL ATOMS
C           I     = COUNTS ALL ATOMS, INCLUDING GHOSTS
C
      NRATM=0
      I=0
      NERR=0
  220 CONTINUE
      IF(MOPAC) THEN
         CALL RDCARD('MBLDR M ',IEOF)
      ELSE
         CALL RDCARD('MBLDR G ',IEOF)
      END IF
      IF(IEOF.EQ.1) STOP
      I = I + 1
      CALL GSTRNG(ATM(I),-4)
      IF(ATM(I).EQ.'    ') GO TO 300
C
C          READ THE Z-MATRIX IN MOPAC STYLE
C
      IF(MOPAC) CALL RDMPC(UNITS,BL(I),ALPHA(I),BETA(I),IZ(I,1),
     *                     IZ(I,2),IZ(I,3),I)
      IF(MOPAC) GO TO 240
C
C          READ THE Z-MATRIX IN GAUSSIAN STYLE
C
      IF(I.EQ.1) GO TO 240
      CALL RDZMT(I,IZ(I,1),BL(I),BL2(I),NEG(I,1))
      BL(I) = UNITS * BL(I)
      IF(I.EQ.2) GO TO 240
      CALL RDZMT(I,IZ(I,2),ALPHA(I),ALPHA2(I),NEG(I,2))
      IF(IZ(I,2).EQ.IZ(I,1)) THEN
         WRITE(IW,9020) I
         NERR = NERR+1
      END IF
      IF(I.EQ.3) GO TO 240
      CALL RDZMT(I,IZ(I,3),BETA(I),BETA2(I),NEG(I,3))
      IF(IZ(I,3).EQ.IZ(I,1)  .OR.  IZ(I,3).EQ.IZ(I,2)) THEN
         WRITE(IW,9020) I
         NERR = NERR+1
      END IF
      IZ(I,4)=IFIND('IZ',IERR)
C
C         TRANSLATE CHEMICAL SYMBOL TO ATOMIC NUMBER
C
  240 CONTINUE
      DO 250 J=1,MAXZ+2
         IF(STRIP(ATM(I)).EQ.ATMLAB(J)) GO TO 270
  250 CONTINUE
      WRITE(IW,9030) ATM(I)
      STOP
  270 CONTINUE
      IAN(I) = J
C
C         GHOST ATOMS (SYMBOL X OR BQ) HAVE CHARGE=0
C
      IF(IAN(I).GT.MAXZ) IAN(I) = 0
      IF(IAN(I).GT.0) NRATM=NRATM+1
      GO TO 220
C
C         ----- WE ARE DONE READING THE ENTIRE Z-MATRIX -----
C         ANY STRING VARIABLES MUST NOW BE COVERTED INTO THEIR
C         NUMERIC VALUES, WITH THE APPROPRIATE SIGN.
C
  300 CONTINUE
      NATOMS = I-1
  310 CONTINUE
      IF(MOPAC) GO TO 400
      CALL RDCARD('MBLDR11G',IEOF)
      IF(IEOF.EQ.1) GO TO 360
      CALL GSTRNG(VAR,-8)
      IF(VAR.EQ.BLANK) GO TO 310
      AVAR = RFIND('AVAR   ',IERR)
      IF(IERR.EQ.1) STOP
C
      MATCH = 0
      DO 320 I=1,NATOMS
         IF(   BL2(I).EQ.VAR) THEN
            BL(I) = NEG(I,1)*AVAR
            MATCH = MATCH+1
         END IF
         IF(ALPHA2(I).EQ.VAR) THEN
            ALPHA(I) = NEG(I,1)*AVAR
            MATCH = MATCH+1
         END IF
         IF( BETA2(I).EQ.VAR) THEN
            BETA(I) = NEG(I,3)*AVAR
            MATCH = MATCH+1
         END IF
  320 CONTINUE
      IF(MATCH.GT.0) GO TO 310
C
C         FOUND A VARIABLE STRING NOT GIVEN IN THE Z-MATRIX
C
      WRITE(IW,9040) VAR
      NERR=NERR+1
      GO TO 310
C
C         NOW, MAKE SURE ALL SYMBOLS RECEIVED A NUMERIC VALUE
C
  360 CONTINUE
      DO 370 I=1,NATOMS
         IF(   BL2(I).NE.BLANK .AND.    BL(I).EQ.BADVAL) THEN
            WRITE(IW,9050) BL2(I)
            NERR=NERR+1
         END IF
         IF(ALPHA2(I).NE.BLANK .AND. ALPHA(I).EQ.BADVAL) THEN
            WRITE(IW,9050) ALPHA2(I)
            NERR=NERR+1
         END IF
         IF( BETA2(I).NE.BLANK .AND.  BETA(I).EQ.BADVAL) THEN
            WRITE(IW,9050) BETA2(I)
            NERR=NERR+1
         END IF
  370 CONTINUE
C
C     ----- Z-MATRIX IS COMPLETELY PROCESSED -----
C              STOP IF THERE WERE BOOBOOS
C              PRINT OUT NUMERIC Z MATRIX
C              CONVERT ANGLES TO RADIANS
C
  400 CONTINUE
      IF(NERR.GT.0) THEN
         WRITE(IW,*) ' '
         WRITE(IW,*) '   OOPS!    FIX ALL THE ERRORS, AND TRY AGAIN.'
         WRITE(IW,*) ' '
         STOP
      END IF
C
      WRITE(IW,9060)
      DO 410 I=1,NATOMS
         IF(I.EQ.1) WRITE(IW,9070) ATM(I)
         IF(I.EQ.2) WRITE(IW,9070) ATM(I),IZ(I,1),BL(I)
         IF(I.EQ.3) WRITE(IW,9070) ATM(I),IZ(I,1),BL(I),
     *                                    IZ(I,2),ALPHA(I)
         IF(I.GE.4) WRITE(IW,9070) ATM(I),IZ(I,1),BL(I),
     *                                    IZ(I,2),ALPHA(I),
     *                                    IZ(I,3),BETA(I),IZ(I,4)
  410 CONTINUE
      WRITE(IW,*)
C
      M=NATOMS
      IF(M.LT.3) GO TO 500
      DO 420 J=3,M
         ALPHA(J) = ALPHA(J)*PI/ONE80
  420 CONTINUE
      IF(M.LT.4) GO TO 500
      DO 430 J=4,M
         BETA(J) = BETA(J)*PI/ONE80
  430 CONTINUE
C
C         ----- BEGIN TO GENERATE CARTESIAN COORDINATES -----
C               HANDLE ATOMS 1, 2, 3 AS SPECIAL CASES
C
  500 CONTINUE
      C(1,1)=ZERO
      C(1,2)=ZERO
      C(1,3)=ZERO
C
      C(2,1)=ZERO
      C(2,2)=ZERO
      C(2,3)=BL(2)
      IF(M.LT.3) GO TO 700
C
      C(3,1)=BL(3)*SIN(ALPHA(3))
      C(3,2)=ZERO
      IF(IZ(3,1).EQ.1) C(3,3) = BL(3)*COS(ALPHA(3))
      IF(IZ(3,1).EQ.2) C(3,3) = C(2,3)-BL(3)*COS(ALPHA(3))
      I=3
      IF(ABS(C(3,1)).GE.TM5) GO TO 600
      DO 510 I = 4,MXATM
         IF(I.GT.M  .OR.  ABS(C(I-1,1)).GE.TM5) GO TO 600
         C(I,1) = BL(I)*SIN(ALPHA(I))
         C(I,2) = ZERO
         ITEMP = IZ(I,1)
         JTEMP = IZ(I,2)
         C(I,3)=C(ITEMP,3)-BL(I) * COS(ALPHA(I)) *
     *           SIGN(ONE,C(ITEMP,3)-C(JTEMP,3))
  510 CONTINUE
C
C               LOOP OVER COORDINATES OF ATOMS 4 TO M
C
  600 CONTINUE
      K=I
      IF(I.EQ.3) K=4
      IF(K.GT.M) GO TO 700
      DO 690 J = K,M
      IF(IZ(J,4).NE.0) GO TO 630
C
C                  ****** USE DIHEDRAL ANGLE *****
C
      CALL RELVEC(V1,IZ(J,2),IZ(J,3))
      CALL UNIVEC(AL1,V1)
C
C     V1 IS A VECTOR FROM ATOM IZ(J,3) TO ATOM IZ(J,2)
C     AL1 IS A UNIT VECTOR OF V1.
C     BL(IZ(J,2)) IS BONDLENGTH OF ATOM IZ(J,2)
C
      CALL RELVEC(V2,IZ(J,1),IZ(J,2))
      CALL UNIVEC(AL2,V2)
C
C     V2 IS THE VECTOR FROM ATOM IZ(J,2) TO ATOM IZ(J,1)
C     AL2 IS THE UNIT VECTOR OF V2.
C     BL(IZ(J,1)) IS BONDLENGTH DEFINING ATOM IZ(J,1)
C
      CALL VECPRD(VP,AL1,AL2)
      DO 610 I = 1,3
         AL3(I) = VP(I)/
     *        SQRT(ONE-(AL1(1)*AL2(1)+AL1(2)*AL2(2)+AL1(3)*AL2(3))**2)
  610 CONTINUE
C
C     AL3 IS THE UNIT VECTOR OF VP.ALPHA(IZ(J,1))IS THE ANGLE DEFINING
C     ATOM IZ(J,1)
C
      CALL VECPRD(AL4,AL3,AL2)
C
C     AL4,AL3,AL2 ARE A NEW SET OF MUTUALLY ORTHOGONAL AXES. WE WILL
C     GET COORD OF ATOM J IN TERMS OF THESE AXES RELATIVE TO ATOM IZ(J)
C
      DO 620 I=1,3
         VJ(I) = BL(J)*(-AL2(I)*COS(ALPHA(J))+AL4(I)*SIN(ALPHA(J))*
     *           COS(BETA(J))+AL3(I)*SIN(ALPHA(J))*SIN(BETA(J)))
C
C     VJ IS THE VECTOR FROM ATOM IZ(J,1) TO ATOM J
C
         ITEMP = IZ(J,1)
         C(J,I) = VJ(I) + C(ITEMP,I)
         IF(ABS(C(J,I)).LT.TM5) C(J,I)=ZERO
  620 CONTINUE
      GO TO 690
C
C              ***** USE SECOND BOND ANGLE *****
C
  630 CONTINUE
      IF(IABS(IZ(J,4)).NE.1) GO TO 650
      CALL RELVEC(V1,IZ(J,1),IZ(J,3))
      CALL UNIVEC(AL1,V1)
      CALL RELVEC(V2,IZ(J,2),IZ(J,1))
      CALL UNIVEC(AL2,V2)
      ZETA = -(AL1(1)*AL2(1)+AL1(2)*AL2(2)+AL1(3)*AL2(3))
      OMZSQ = ONE - ZETA * ZETA
      A(J) = (-COS(BETA(J))+ZETA*COS(ALPHA(J)))/(OMZSQ)
      B(J) = (COS(ALPHA(J))-ZETA*COS(BETA(J)))/(OMZSQ)
      TEMP=ZERO
      IF(ZETA.LT.ZERO) TEMP=PI
      GAMMA = PI/TWO
      IF(ZETA.NE.ZERO) GAMMA = ATAN (SQRT(OMZSQ)/ZETA) +TEMP
      DJ=ZERO
      IF (ABS(GAMMA+ALPHA(J)+BETA(J)-TWO*PI).GT.TM5)
     *     D(J) = IZ(J,4)*(SQRT(ONE+A(J)*COS(BETA(J))-B(J)*
     *            COS(ALPHA(J))))/SQRT(OMZSQ)
      CALL VECPRD(V3,AL1,AL2)
      DO 640 I = 1,3
         AL3(I) = A(J)*AL1(I)+B(J)*AL2(I)+D(J)*V3(I)
         VJ(I) = BL(J)*AL3(I)
         ITEMP = IZ(J,1)
         C(J,I) = VJ(I)+C(ITEMP,I)
         IF(ABS(C(J,I)).LT.TM5) C(J,I)=ZERO
  640 CONTINUE
      GO TO 690
C
C            ***** USE BOND-PLANE ANGLE ******
C
C     THIS PART IS USED IF ATOM IS DEFINED BY ONE BONDANGLE AND BY
C     THE ANGLE WHICH BOND IZ(J,1)-J MAKES WITH THE PLANE OF
C     IZ(J,1), IZ(J,2) AND IZ(J,3)
C
C     CAUTION!
C     THIS PART IS DOCUMENTED BECAUSE I DON'T THINK IT IS CORRECT!
C
  650 CONTINUE
      CALL RELVEC(V1,IZ(J,1),IZ(J,3))
      CALL UNIVEC(AL1,V1)
      CALL RELVEC(V2,IZ(J,2),IZ(J,1))
      CALL UNIVEC(AL2,V2)
      ZETA = -(AL1(1)*AL2(1)+AL1(2)*AL2(2)+AL1(3)*AL2(3))
      OMZSQ = ONE - ZETA * ZETA
      CALL VECPRD(V3,AL1,AL2)
C
C     BETA(J) HERE REFERS TO 90-ANGLE WHICH BOND IZ(J,1)-J MAKES
C     WITH THE AFOREMENTIONED PLANE
C
      V3MAG = SQRT(V3(1)*V3(1) + V3(2)*V3(2) + V3(3)*V3(3))
      A(J)=(COS(BETA(J))/(OMZSQ))*V3MAG
      B(J)=SQRT((ONE-COS(ALPHA(J))**2
     *              - A(J)*COS(BETA(J))*V3MAG)/OMZSQ)
      IF(IZ(J,4).EQ.-2) B(J) = -B(J)
      D(J) = B(J)*ZETA+COS(ALPHA(J))
      DO 660 I=1,3
         AL3(I) = B(J)*AL1(I)+D(J)*AL2(I)+A(J)*V3(I)
         VJ(I) = BL(J)*AL3(I)
         ITEMP = IZ(J,1)
         C(J,I) = VJ(I) + C(ITEMP,I)
         IF(ABS(C(J,I)).LT.TM5) C(J,I)=ZERO
  660 CONTINUE
  690 CONTINUE
C
C         ----- WE NOW HAVE CARTESIAN COORDINATES -----
C         THESE ARE IN ARBITRARY "Z-MATRIX ORIENTATION"
C
  700 CONTINUE
      WRITE(IW,9080)
      DO 720 J=1,M
         IF(IAN(J).LE.0) GO TO 720
         ZNUC = IAN(J)
         WRITE(IW,9090) ATM(J),ZNUC,(C(J,I),I=1,3)
  720 CONTINUE
C
C        COMPUTE INTERNUCLEAR DISTANCES AND NUCLEAR REPULSION ENERGY
C
      WRITE(IW,9100)
      REPNUC=ZERO
      IJ=0
      IATM=0
      FACT = ONE
      DO 820 I=1,M
         ZA=IAN(I)
         IF(ZA.EQ.ZERO) GO TO 820
         IATM=IATM+1
         IATNO(IATM) = IAN(I)
         DO 800 J=1,I
            ZB = IAN(J)
            IF(ZB.EQ.ZERO) GO TO 800
            IJ=IJ+1
            IF (I .EQ. J) DSTNCE(IJ)=ZERO
            IF (I .EQ. J) GO TO 800
            RAB = SQRT((C(I,1)-C(J,1))**2
     *               + (C(I,2)-C(J,2))**2
     *               + (C(I,3)-C(J,3))**2)
            DSTNCE(IJ)=RAB
            REPNUC=REPNUC + TOANGS * ZA * ZB/RAB
  800    CONTINUE
  820 CONTINUE
      CALL PRTTRI(IW,TITL,DSTNCE,NRATM,ATMLAB,IATNO)
      WRITE(IW,9110) REPNUC
C
C            COMPUTE PRINCIPAL AXIS COORDINATES
C
      IF(DOPRIN) CALL PRAXIS(AMASS,MAXZ,IW,ICHARG,MULTIP,NX,NY,NZ)
C
C            PUNCH OUT MOLPLT INPUT FILE
C
      CALL MOLPLT(IW,TITLE,IZ,CART)
C
C            PUNCH OUT CHEM3D+ INPUT FILE
C
      CALL CHEM3D(IW)
C
C            SDIST CALCULATES THE MASS-WEIGHTED ARC DISTANCE
C
      IF(SDIST) THEN
        DO 900 I = 1,NATOMS  
           DO 850 J = 1,3
              COLD(I,J) = C(I,J)
  850      CONTINUE
  900   CONTINUE
        SSAVE = SDIST
        GO TO 50
      ENDIF
C
      IF(SSAVE) THEN
        DIST = ZERO
        CALL DISTS(COLD,AMASS,DIST)
        WRITE(IW,9130)DIST
      ENDIF
C
      STOP
C
 9000 FORMAT('* * * MODEL BUILDER * * *')
 9010 FORMAT(/A)
 9020 FORMAT('*** ERROR *** Z-MATRIX CARD',I4,
     *       ' HAS DUPLICATE ATOM INTEGERS')
 9030 FORMAT('*** ERROR *** ILLEGAL CHEMICAL SYMBOL, ',A4,' USED')
 9040 FORMAT('*** ERROR *** VALUE GIVEN FOR ',A8,
     *       ', THIS SYMBOL WAS NOT IN THE Z-MATRIX.')
 9050 FORMAT('*** ERROR *** SYMBOL ',A8,' IN THE Z-MATRIX',
     *       ' WAS NOT GIVEN A VALUE.')
 9060 FORMAT(/'YOUR FULLY SUBSTITUTED Z-MATRIX IS')
 9070 FORMAT(A4,1X,I3,F12.7,I3,F10.4,I3,F10.4,I3)
 9080 FORMAT(/5X,'NUCLEAR COORDINATES IN Z-MATRIX ORIENTATION'/
     *        1X,'ATOM',2X,'ZNUC',9X,'X',20X,'Y',20X,'Z'/
     *        1X,33(2H- ))
 9090 FORMAT(A4,1X,F5.1,F16.10,2F20.10)
 9100 FORMAT(/10X,'INTERNUCLEAR DISTANCES')
 9110 FORMAT(/5X,'NUCLEAR REPULSION =',F18.10,' HARTREE')
 9130 FORMAT(/5X,'THE MASS-WEIGHTED ARC DISTANCE IS ',F10.5, 
     *           ' BOHR*SQRT(AMU)')
      END
C*PROGRAM MBLDR *DECK RELVEC
      SUBROUTINE RELVEC(R,J,K)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (MXATM=500)
      CHARACTER*4 ATM
      DIMENSION R(3)
      COMMON /INFO  / C(MXATM,3),ATM(MXATM),IAN(MXATM),NATOMS
C
C     R IS THE RELATIVE VECTOR FROM ATOM K TO ATOM J
C
      DO 10 I=1,3
         R(I)=C(J,I)-C(K,I)
   10 CONTINUE
      RETURN
      END
C*PROGRAM MBLDR *DECK UNIVEC
      SUBROUTINE UNIVEC(AL,R)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION AL(3),R(3)
      DATA ONE/1.0D+00/
C
C     AL IS THE UNIT VECTOR OF R
C
      FAC = ONE/SQRT(R(1)*R(1) + R(2)*R(2) + R(3)*R(3))
      DO 10 I=1,3
         AL(I) = R(I) * FAC
   10 CONTINUE
      RETURN
      END
C*PROGRAM MBLDR *DECK VECPRD
      SUBROUTINE VECPRD(VP,X,Y)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION VP(3),X(3),Y(3)
C
C     VP IS THE VECTOR PRODUCT OF X CROSSED Y
C
      VP(1)=X(2)*Y(3)-X(3)*Y(2)
      VP(2)=X(3)*Y(1)-X(1)*Y(3)
      VP(3)=X(1)*Y(2)-X(2)*Y(1)
      RETURN
      END
C*PROGRAM MBLDR *DECK DOTPRD
      FUNCTION DOTPRD(Q1,Q2)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION Q1(3),Q2(3)
      DOTPRD=Q1(1)*Q2(1)+Q1(2)*Q2(2)+Q1(3)*Q2(3)
      RETURN
      END
C*PROGRAM MBLDR *DECK PRAXIS
      SUBROUTINE PRAXIS(AMASS,MAXZ,IW,ICHARG,MULTIP,NX,NY,NZ)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (MXATM=500)
      DOUBLE PRECISION IXX,IYY,IZZ
      DIMENSION AMASS(MAXZ),T(3,3),A(3,3)
      CHARACTER*4 STRIP
      CHARACTER*4 ATM
      COMMON /INFO  / C(MXATM,3),ATM(MXATM),IAN(MXATM),NATOMS
      DATA ZERO,TM5,TM8,TM13/0.0D+0,1.0D-5,1.0D-8,1.0D-13/
      DATA TOANGS,ONE/0.52917724924D+00,1.0D+00/
C
C   FIND CENTER OF MASS COORDINATES
C
      TM=ZERO
      XCM=ZERO
      YCM=ZERO
      ZCM=ZERO
      DO 100 I=1,NATOMS
         L=IAN(I)
         IF(L.EQ.0) GO TO 100
         IF(L.GT.MAXZ) WRITE(IW,950) L,MAXZ
         IF(L.GT.MAXZ) RETURN
         TEMP=AMASS(L)
         TM=TM+TEMP
         XCM=XCM+TEMP*C(I,1)
         YCM=YCM+TEMP*C(I,2)
         ZCM=ZCM+TEMP*C(I,3)
  100 CONTINUE
      XCM=XCM/TM
      YCM=YCM/TM
      ZCM=ZCM/TM
      IF(ABS(XCM).LT.TM5) XCM=ZERO
      IF(ABS(YCM).LT.TM5) YCM=ZERO
      IF(ABS(ZCM).LT.TM5) ZCM=ZERO
      WRITE(IW,900) XCM,YCM,ZCM
      DO 120 I=1,NATOMS
         C(I,1)=C(I,1)-XCM
         C(I,2)=C(I,2)-YCM
         C(I,3)=C(I,3)-ZCM
  120 CONTINUE
C
C  NOW FIND MOMENTS AND PRODUCTS OF INERTIA
C
      XX=ZERO
      YY=ZERO
      ZZ=ZERO
      XY=ZERO
      XZ=ZERO
      YZ=ZERO
      DO 200 I=1,NATOMS
         L=IAN(I)
         IF(L.EQ.0) GO TO 200
         TEMP=AMASS(L)
         XC=C(I,1)
         YC=C(I,2)
         ZC=C(I,3)
         TEMP1=TEMP*XC
         TEMP2=TEMP*YC
         TEMP3=TEMP*ZC
         XX=XX+TEMP2*YC+TEMP3*ZC
         YY=YY+TEMP1*XC+TEMP3*ZC
         ZZ=ZZ+TEMP1*XC+TEMP2*YC
         XY=XY-TEMP1*YC
         XZ=XZ-TEMP1*ZC
         YZ=YZ-TEMP2*ZC
  200 CONTINUE
      IF(ABS(XY).GT.TM8) GO TO 220
      IF(ABS(XZ).GT.TM8) GO TO 220
      IF(ABS(YZ).GT.TM8) GO TO 220
      GO TO 400
  220 CONTINUE
      WRITE(IW,905)
      WRITE(IW,*)
      T(1,1)=XX
      T(2,2)=YY
      T(3,3)=ZZ
      T(2,1)=XY
      T(1,2)=XY
      T(3,1)=XZ
      T(1,3)=XZ
      T(3,2)=YZ
      T(2,3)=YZ
      CALL JACOB1(IW,T,A,3,TM13)
C
C     ADJUST ROTATION MATRIX SO HANDEDNESS IS UNCHANGED
C     A PROPER ROTATION MUST HAVE A POSITIVE DETERMINATE
C
      COF11 = T(2,2)*T(3,3) - T(2,3)*T(3,2)
      COF12 = T(2,1)*T(3,3) - T(2,3)*T(3,1)
      COF13 = T(2,1)*T(3,2) - T(2,2)*T(3,1)
      DET = T(1,1)*COF11 - T(1,2)*COF12 + T(1,3)*COF13
      IF(DET.LT.ZERO) THEN
         DO 240 I=1,3
            T(I,1) = -T(I,1)
  240    CONTINUE
      END IF
C
      WRITE(IW,907)
      WRITE(IW,935) ((A(I,J),J=1,3),I=1,3)
      WRITE(IW,*)
      DO 350 I=1,NATOMS
         TEMP1=C(I,1)
         TEMP2=C(I,2)
         TEMP3=C(I,3)
         T(1,1)=TEMP1*A(1,1)+TEMP2*A(2,1)+TEMP3*A(3,1)
         T(2,1)=TEMP1*A(1,2)+TEMP2*A(2,2)+TEMP3*A(3,2)
         T(3,1)=TEMP1*A(1,3)+TEMP2*A(2,3)+TEMP3*A(3,3)
         DO 340 J=1,3
            C(I,J)=T(J,1)
            IF(ABS(C(I,J)).LT.TM5) C(I,J)=ZERO
  340    CONTINUE
  350 CONTINUE
C
  400 CONTINUE
      WRITE(IW,910)
      DO 420 I=1,NATOMS
         IF(IAN(I).LE.0) GO TO 420
         ZNUC=IAN(I)
         TEMP1 = C(I,1)
         TEMP2 = C(I,2)
         TEMP3 = C(I,3)
         C(I,NX) = TEMP1
         C(I,NY) = TEMP2
         C(I,NZ) = TEMP3
         WRITE(IW,920) STRIP(ATM(I)),ZNUC,C(I,1),C(I,2),C(I,3)
  420 CONTINUE
C
C            TEST FOR DIAGONAL PRODUCT OF INERTIA TENSOR
C
  500 CONTINUE
      XY=ZERO
      XZ=ZERO
      YZ=ZERO
      XX=ZERO
      YY=ZERO
      ZZ=ZERO
      DO 600 I=1,NATOMS
         L=IAN(I)
         IF(L.EQ.0) GO TO 600
         TEMP=AMASS(L)
         XC=C(I,1)
         YC=C(I,2)
         ZC=C(I,3)
         XY=XY+TEMP*XC*YC
         XZ=XZ+TEMP*XC*ZC
         YZ=YZ+TEMP*YC*ZC
         XX=XX+TEMP*XC*XC
         YY=YY+TEMP*YC*YC
         ZZ=ZZ+TEMP*ZC*ZC
  600 CONTINUE
      WRITE(IW,930)
      WRITE(IW,940) XX,XY,YY,XZ,YZ,ZZ
      FACT = ONE
      IXX = FACT * (YY + ZZ)
      IYY = FACT * (XX + ZZ)
      IZZ = FACT * (XX + YY)
      WRITE(IW,960) IXX,IYY,IZZ
      RETURN
C
  900 FORMAT(/'TRANSLATING TO CENTER OF MASS COORDINATES'/
     *        5X,'AT  X=',F14.8,'   Y=',F14.8,'  Z=',F14.8)
  905 FORMAT('ROTATING TO DIAGONALIZE THE MOMENT OF INERTIA TENSOR')
  907 FORMAT('THE ROTATION MATRIX IS'/
     *       1X,9X,'X',16X,'Y',16X,'Z')
  910 FORMAT(/5X,'ATOMIC COORDINATES IN PRINCIPAL AXIS SYSTEM'/
     *        1X,'ATOM',2X,'ZNUC',9X,'X',20X,'Y',20X,'Z'/
     *        1X,33(2H- ))
  920 FORMAT(A4,1X,F5.1,F16.10,2F20.10)
  930 FORMAT(/'THE PRODUCT OF INERTIA TENSOR (SUM MI*QI*QJ) IS NOW'/
     *        1X,9X,'X',16X,'Y',16X,'Z')
  935 FORMAT('X',2X,1P,3E16.7/'Y',2X,1P,3E16.7/'Z',2X,1P,
     *       3E16.7)
  940 FORMAT('X',2X,1P,E16.7/'Y',2X,1P,2E16.7/'Z',2X,1P,3E16.7)
  950 FORMAT('ATOMIC NUMBER',I4,' IS GREATER THAN',I4,
     *          ', EXCEEDING BUILT-IN MASS TABLE')
  960 FORMAT('THE MOMENTS OF INERTIA ARE (IN AMU-ANGSTROM**2)'/
     *       1X,'IXX=',F10.3,'   IYY=',F10.3,'   IZZ=',F10.3)
      END
C*PROGRAM MBLDR *DECK JACOB1
      SUBROUTINE JACOB1(IW,A,S,NN,RRHO)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION A(3,3),S(3,3)
      INTEGER P,Q,QLIM
      DOUBLE PRECISION INT1,MU
C
C  JACOBI DIAGONALIZATION ROUTINE FOR PRINCIPAL AXIS TRANSFORMATION
C
      N=NN
      RHO=RRHO
C
C A IS THE INPUT MATRIX TO BE DIAGONALIZED AND WILL CONTAIN THE EIGEN-
C VALUES AT THE END OF JACOBI   S WILL CONTAIN THE EIGENVECTORS IN
C COLUMNS,N IS THE SIZE OF THE A MATRIX AND RHO IS THE CONV. CRITERION
C
      IF (N-1) 1,2,3
C
    1 WRITE(IW,1001) N
 1001 FORMAT(4H N= ,I3,39H IS TOO SMALL.RETURN TO CALLING PROGRAM)
      RETURN
C
    2 WRITE(IW,1002) A(1,1)
 1002 FORMAT(22H IN JACOBI,MATRIX A = ,F12.6)
      RETURN
C
    3 IF (N-100) 5,5,4
    4 WRITE(IW,1003) N
 1003 FORMAT(4H N= ,I5,39H IS TOO LARGE.RETURN TO CALLING PROGRAM)
      RETURN
C
C NOW SET S EQUAL TO THE IDENTITY MATRIX
C
    5 CONTINUE
      DO 7 J=1,N
      DO 6 I=1,N
    6 S(I,J)=0.0D+00
    7 S(J,J)=1.0D+00
      INT1=0.0D+00
      ENORM=A(1,1)*A(1,1)
      TRACE=A(1,1)
      JACERR=0
      DO 100 I=2,N
         JLIM=I-1
         DO 8 J=1,JLIM
            TEMP=A(I,J)
            INT1=INT1+2.0D+00*TEMP*TEMP
    8    CONTINUE
         TEMP1=A(I,I)
         ENORM=ENORM+TEMP1*TEMP1
  100 TRACE=TRACE+TEMP1
      ENORM=ENORM+INT1
C
C TRACE IS THE TRACE OF THE INITIAL A MATRIX TO BE COMPARED WITH THE
C SUM OF THE EIGENVALUES AT THE END OF JACOBI.  ENORM IS THE SUM OF
C THE SQUARES OF THE ELEMENTS OF THE INITIAL A MATRIX (EUCLIDIAN NORM)
C TO BE COMPARED WITH THE SUM OF THE SQUARES OF THE EIGENVALUES AT
C THE END OF JACOBI.
C
      THRESH=SQRT(INT1)
      RHO=RHO*THRESH/N
      IFLAG=0
    9 THRESH=THRESH/N
      IF (THRESH-RHO) 10,11,11
   10 THRESH=RHO
   11 CONTINUE
      DO 23 P=2,N
      QLIM=P-1
      DO 23 Q=1,QLIM
      IF(ABS(A(P,Q))-THRESH)23,12,12
   12 V1=A(Q,Q)
      V2=A(P,Q)
      V3=A(P,P)
      MU=0.50D+00*(V1-V3)
C
C CHECK TO SEE IF THE CHOSEN ROTATION IS LESS THAN THE ROUNDING ERROR.
C IF SO THEN DO NOT ROTATE.
C
      IF(ABS(V2)-1.D-12*ABS(MU))23,23,13
   13 IFLAG=1
C
C CHECK TO SEE IF THE CHOSEN ROTATION IS VERY CLOSE TO 45 DEGREES.
C IF SO SET BOTH SIN AND COS TO 1/SQRT(2).
C
      IF(ABS(MU)-1.D-08*ABS(V2))14,14,15
   14 OMEGA=-1.0D+00
      GO TO 16
   15 OMEGA=-SIGN(1.0D+00,MU)*V2/SQRT(V2*V2+MU*MU)
   16 CONTINUE
      SINT=OMEGA/SQRT(2.0D+00*(1.0D+00+SQRT(1.0D+00-OMEGA*OMEGA)))
      COST=SQRT(1.0D+00-SINT*SINT)
      DO 22 I=1,N
      IF (I-P)18,17,17
   17 INT1=A(I,Q)*COST-A(I,P)*SINT
      A(I,P)=A(I,Q)*SINT+A(I,P)*COST
      A(I,Q)=INT1
      GO TO 21
   18 IF(I-Q) 19,20,20
   19 INT1=A(Q,I)*COST-A(P,I)*SINT
      A(P,I)=A(Q,I)*SINT+A(P,I)*COST
      A(Q,I)=INT1
      GO TO 21
   20 INT1=A(I,Q)*COST-A(P,I)*SINT
      A(P,I)=A(I,Q)*SINT+A(P,I)*COST
      A(I,Q)=INT1
   21 CONTINUE
      INT1=S(I,Q)*COST-S(I,P)*SINT
      S(I,P)=S(I,Q)*SINT+S(I,P)*COST
      S(I,Q)=INT1
   22 CONTINUE
      A(Q,Q)=V1*COST*COST+V3*SINT*SINT-2.0D+00*V2*SINT*COST
      A(P,P)=V1*SINT*SINT+V3*COST*COST+2.0D+00*V2*SINT*COST
      A(P,Q)=(V1-V3)*SINT*COST+V2*(COST*COST-SINT*SINT)
   23 CONTINUE
      IF (IFLAG-1) 25,24,24
   24 IFLAG=0
      GO TO 11
   25 IF (THRESH-RHO) 27,27,26
   26 GO TO 9
C
C JACOBI HAS CONVERGED
C
   27 CONTINUE
      TRACE1=0.0D+00
      ENORM1=0.0D+00
      DO 101 I=1,N
      TRACE1=TRACE1+A(I,I)
      ENORM1=ENORM1+A(I,I)*A(I,I)
  101 CONTINUE
      IF(ABS(TRACE-TRACE1)-1.D-06) 103,102,102
  102 JACERR=JACERR+1
      WRITE(IW,1005)
 1005 FORMAT(7H TRACE ,8H TRACE1 )
      WRITE(IW,1007) TRACE,TRACE1
  103 IF(ABS(ENORM-ENORM1)-1.D-06) 105,104,104
  104 JACERR=JACERR+2
      WRITE(IW,1006)
      WRITE(IW,1007) ENORM,ENORM1
 1006 FORMAT(8H ENORM  ,8H ENORM1 )
 1007 FORMAT(2F14.7)
  105 CONTINUE
      RETURN
      END
C*PROGRAM MBLDR *DECK PRTTRI
      SUBROUTINE PRTTRI(IW,TITL,A,IORDER,ATMLAB,IATNO)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (MXATM=500)
      INTEGER IATNO(MXATM)
      CHARACTER*1 IDASH
      CHARACTER*8 TITL
      CHARACTER*4 LABEL
      CHARACTER*4 ATMLAB(*)
      DIMENSION A(1)
      DATA IDASH/'-'/
C
C  PRINT AN ARRAY IN SYMMETRIC STORAGE MODE
C         IW         - PRINT LOGICAL FILE NUMBER
C         TITL       - EIGHT CHARACTER ARRAY HEADING
C         A          - ARRAY TO BE PRINTED
C         IORDER    >0 ORDER OF ARRAY A
C                   <0 NUMBER OF ELEMENTS IN A
C
C
      IF(IW.LT.0 .OR. IORDER.LE.0) RETURN
      NORDER=IORDER
      IF(NORDER.LT.0) STOP
      LENPGE=MIN(8,NORDER)
      DO 120 I0=1,NORDER,8
         IL=MIN(NORDER,I0+7)
         WRITE(IW,900) (IDASH,J=1,LENPGE)
         WRITE(IW,901) TITL,(ATMLAB(IATNO(I)),I=I0,IL)
         IL=-1
         DO 110 I=I0,NORDER
            IL=IL+1
            J0=I0+(I*I-I)/2
            JL=J0+MIN(IL,7)
            LABEL=ATMLAB(IATNO(I))
            WRITE(IW,902) LABEL,(A(J),J=J0,JL)
 110     CONTINUE
 120  CONTINUE
      RETURN
C
 900  FORMAT(4(2H- ),8(A1,1X,3(2H- )))
 901  FORMAT(A8,8A8)
 902  FORMAT(A4,2X,8F8.4)
      END
C*PROGRAM MBLDR *DECK RDCART
      SUBROUTINE RDCART(UNITS,IR,NRATM)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (MXATM=500)
      CHARACTER*4 ATM
      COMMON /INFO  / C(MXATM,3),ATM(MXATM),IAN(MXATM),NATOMS
C
      I = 0
C
  100 CONTINUE
      CALL RDCARD('MBLDR C ',IEOF)
      I = I + 1
      IF(IEOF.EQ.1)        GO TO 110
      CALL GSTRNG(ATM(I),-4)
      IF(ATM(I).EQ.'    ') GO TO 110
      IAN(I) = IFIND('IAN     ',IERR)
      C(I,1) = RFIND('C1      ',IERR)*UNITS
      C(I,2) = RFIND('C2      ',IERR)*UNITS
      C(I,3) = RFIND('C3      ',IERR)*UNITS
      GO TO 100
C
  110 CONTINUE
      NRATM = I - 1
      RETURN
      END
C*PROGRAM MBLDR *DECK RDZMT
      SUBROUTINE RDZMT(NATS,IC,AITM,AITM2,NEG)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (MXATM=500)
C
      LOGICAL NUMERC
      CHARACTER*8 AITM2
      CHARACTER*9 AITM3
      CHARACTER*1 PART1
      CHARACTER*4 TEMPAT
      CHARACTER*4 ATM
C
      COMMON /INFO  / C(MXATM,3),ATM(MXATM),IAN(MXATM),NATOMS
C
      IERR = 0
      IC = 0
      NEG = 1
C
      CALL GSTRNG(TEMPAT,-4)
      IF(NUMERC(TEMPAT)) THEN
        CALL REREAD
        IC=IFIND('IZ      ',IERR)
      ELSE
        K=0
        DO 10 I=1,NATS
          IF(TEMPAT.EQ.ATM(I))  K = I
   10   CONTINUE
        IF (K.EQ.0) STOP
        IC = K
      ENDIF
C
      IERR=30
      TEMP=RFIND('AITM    ',IERR)
      IF(IERR.EQ.0) THEN
         AITM = TEMP
      ELSE
         CALL REREAD
         CALL GSTRNG(AITM3,-9)
         READ(UNIT=AITM3,FMT=9000) PART1,AITM2
         IF(PART1.EQ.'-') NEG = -1
         IF(NEG.EQ.-1) RETURN
         READ(UNIT=AITM3,FMT=9010) AITM2,PART1
      END IF
 9000 FORMAT(A1,A8)
 9010 FORMAT(A8,A1)
      RETURN
      END
C
C*PROGRAM MBLDR *DECK MOLPLT
      SUBROUTINE MOLPLT(IW,TITLE,IZ,CART)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      PARAMETER (MXATM=500)
      LOGICAL CART
      CHARACTER*4  ATM,SKINDS,STRIP
      CHARACTER*80 TITLE
      DIMENSION KINDS(MXATM),SKINDS(MXATM),IZ(MXATM,4),
     *          JDUMMY(MXATM),ICON(MXATM)
C
      COMMON /INFO  / C(MXATM,3),ATM(MXATM),IAN(MXATM),NATOMS
C
C     ----- PUNCH AN INPUT FILE FOR THE -MOLPLT- PROGRAM -----
C
      WRITE(IW,8000)
C
C     ----- GET KINDS OF ATOMS AND ELIMINATE DUMMY IF ANY -----
C
      NKINDS=1
      NDUMMY=0
      IF(IAN(1).EQ.0) THEN
         NDUMMY = NDUMMY + 1
         JDUMMY(1) = 1
         KINDS(1) = IAN(2)
         SKINDS(1) = ATM(2)
         L = 3
      ELSE
         KINDS(1) = IAN(1)
         SKINDS(1) = ATM(1)
         L = 2
      END IF
      DO 120 IAT=L,NATOMS
         IF(IAN(IAT).EQ.0) THEN
            NDUMMY = NDUMMY + 1
            JDUMMY(IAT) = IAT
            GO TO 120
         END IF
         NUCZ = IAN(IAT)
         MATCH=0
         DO 110 I=1,NKINDS
            IF(NUCZ.EQ.KINDS(I)) MATCH=MATCH+1
  110    CONTINUE
         IF(MATCH.EQ.0) THEN
            NKINDS = NKINDS+1
            KINDS(NKINDS) = NUCZ
            SKINDS(NKINDS) = ATM(IAT)
         END IF
  120 CONTINUE
C
C     ----- CHECK THE CONNECTIVITY BEFORE OPTIONS -----
C
C     --- IF NO DUMMY ---
      IF(NDUMMY.EQ.0) THEN
         ICON(1) = 1
         DO 400 J=3,NATOMS
            ICON(J-1) = IZ(J,1)
  400    CONTINUE
      END IF
C
C     ----- OPTIONS CARD -----
C
      NBONDS = NATOMS-1
      IF(NDUMMY.GT.0) NBONDS = 0
      IF(CART) NBONDS=0
      WRITE(IW,8010) NATOMS-NDUMMY,NKINDS,NBONDS
      WRITE(IW,8015) TITLE
C
C     ----- PUNCH ATOMIC SYMBOL, KOLOR, SIZE -----
C     THE BALL SIZES ARE DETERMINED BY PLAYING WITH THE RADIAL
C     EXPECTATION VALUES OF THE HIGHEST AO IN C,SI,GE,SN,PB.
C
      CARBON = 0.3
      DO 210 I=1,NKINDS
         NUCZ = KINDS(I)
                        SIZE=0.75* CARBON
         IF(NUCZ.GT. 2) SIZE=      CARBON
         IF(NUCZ.GT.10) SIZE=1.6 * CARBON
         IF(NUCZ.GT.18) SIZE=1.7 * CARBON
         IF(NUCZ.GT.36) SIZE=1.9 * CARBON
         IF(NUCZ.GT.54) SIZE=2.0 * CARBON
         IF(NUCZ.GT.86) SIZE=2.1 * CARBON
         WRITE(IW,8020) STRIP(SKINDS(I)),SIZE
  210 CONTINUE
C
C     ----- PUNCH ATOMIC COORDINATES -----
C
      DO 310 IAT=1,NATOMS
         IF(IAN(IAT).EQ.0) GO TO 310
         WRITE(IW,8030) STRIP(ATM(IAT)),(C(IAT,J),J=1,3)
  310 CONTINUE
C
C     ----- LIST BONDING PAIRS -----
C
      IF(NBONDS.GT.0) WRITE(IW,8040) (I+1,ICON(I),I=1,NBONDS)
      WRITE(IW,8050)
      RETURN
C
 8000 FORMAT(//'-------- START OF -MOLPLT- INPUT FILE ----------')
 8010 FORMAT('NATOMS=',I4,'   NKINDS=',I4,'    NBONDS=',I4)
 8015 FORMAT(A)
 8020 FORMAT(A4,'  1  ',F5.2)
 8030 FORMAT(A4,3F12.6)
 8040 FORMAT('BONDATOMS ',6(I4,I4,2X),:,' >'/(7(I4,I4,2X),:,' >'))
 8050 FORMAT('-------- END OF -MOLPLT- INPUT FILE ----------')
      END
C
C*PROGRAM MBLDR *DECK RDMPC
      SUBROUTINE RDMPC(UNITS,BL,ALPHA,BETA,IZ1,IZ2,IZ3,I)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      IERR = 0
      IZ1 = 0
      IZ2 = 0
      IZ3 = 0
      IDUM1 = 0
      IDUM2 = 0
      IDUM3 = 0
C
      BL = 0.0
      ALPHA = 0.0
      BETA = 0.0
C
      BL = UNITS * RFIND('BL      ',IERR)
      IF(IERR.NE.0) STOP
      IF(I.EQ.2) THEN
         IZ1 = 1
         RETURN
      END IF
      IDUM1 = IFIND('IDUM1   ',IERR)
      IF(IERR.NE.0) STOP
      ALPHA = RFIND('ALPHA   ',IERR)
      IF(IERR.NE.0) STOP
      IF(I.EQ.3) THEN
         IZ1 = 2
         IZ2 = 1
         RETURN
      END IF
      IDUM2 = IFIND('IDUM2   ',IERR)
      IF(IERR.NE.0) STOP
      BETA = RFIND('BETA    ',IERR)
      IF(IERR.NE.0) STOP
      IDUM3 = IFIND('IDUM3   ',IERR)
      IF(IERR.NE.0) STOP
      IZ1 = IFIND('IZ1     ',IERR)
      IF(IERR.NE.0) STOP
      IZ2 = IFIND('IZ2     ',IERR)
      IF(IERR.NE.0) STOP
      IZ3 = IFIND('IZ3     ',IERR)
      IF(IERR.NE.0) STOP
C
      RETURN
      END
C*PROGRAM MBLDR *DECK STRIP
      CHARACTER*4 FUNCTION STRIP(ATOM)
      CHARACTER*4 ATOM
      CHARACTER*1 END
      DIMENSION END(11)
      DATA END/'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' '/
C
      STRIP='    '
      DO 20 I=1,4
        DO 10 J=1,11
          IF(ATOM(I:I).EQ.END(J)) GOTO 30
   10   CONTINUE
        STRIP(I:I)=ATOM(I:I)
   20 CONTINUE
   30 CONTINUE
      RETURN
      END
C*PROGRAM MBLDR *DECK NUMERC
      LOGICAL FUNCTION NUMERC(ITEM)
      CHARACTER*8 ITEM
      CHARACTER*1 END
      DIMENSION END(11)
      DATA END/'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-'/
C
      NUMERC = .FALSE.
      DO 10 I=1,11
        IF(ITEM(1:1).EQ.END(I))  NUMERC = .TRUE.
   10 CONTINUE
      RETURN
      END
C*PROGRAM MBLDR *DECK CHEM3D
      SUBROUTINE CHEM3D(IW)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      PARAMETER (MXATM=500)
C
      CHARACTER*4 ATM,STRIP
C
      DIMENSION IATTYP(86)
C
      COMMON /INFO  / C(MXATM,3),ATM(MXATM),IAN(MXATM),NATOMS
C
      DATA IATTYP/5,0,31,42,53,64,73,82,91,0,
     *            111,122,133,144,153,162,171,0,
     *            191,202,
     *            213,224,236,246,256,266,276,284,294,302,
     *            313,324,333,342,351,0,
     *            371,382,
     *            393,404,416,426,436,446,456,464,474,483,
     *            493,504,513,522,531,0,
     *            551,562,573,
     *            0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     *            724,736,746,756,766,776,784,794,803,
     *            813,824,833,842,851,0/
C
C     ----- PUNCH CHEM3D+ INPUT FILE -----
C
      WRITE(IW,8000)
      WRITE(IW,8010) NATOMS
C
      DO 300 IAT=1,NATOMS
         IF(IAN(IAT).EQ.0) GO TO 300
         IF(IAN(IAT).GT.86) THEN
            WRITE(IW,*) 'ATOM HIGHER THAN RADON, CHEM3D QUITS'
            RETURN
         END IF
         WRITE(IW,8030) STRIP(ATM(IAT)),IAT,(C(IAT,J),J=1,3),
     *                  IATTYP(IAN(IAT))
  300 CONTINUE
      WRITE(IW,8040)
      WRITE(IW,8050)
C
 8000 FORMAT('-------- START OF -CHEM3D+- INPUT FILE ----------')
 8010 FORMAT(I3)
 8030 FORMAT(A4,I3,3(1X,F8.4),1X,I3)
 8040 FORMAT(1X)
 8050 FORMAT('-------- END OF -CHEM3D+- INPUT FILE ----------')
C
      RETURN
      END
C*MODULE MBLDR   *DECK DISTS
      SUBROUTINE DISTS(COLD,AMASS,DIST)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      PARAMETER (MXATM=500, MAXZ=104)
C
      CHARACTER*4 ATM
C
      COMMON /INFO  / C(MXATM,3),ATM(MXATM),IAN(MXATM),NATOMS
C
      DIMENSION COLD(MXATM,3), AMASS(MAXZ)
C
      DATA TOANGS/0.52917724924D+00/
C
      DO 100 I=1,NATOMS
         DO 50 J = 1,3
            DIFF = ((COLD(I,J)-C(I,J))/TOANGS)*SQRT(AMASS( IAN(I) ))
            DIST = DIST + DIFF*DIFF
   50    CONTINUE
  100 CONTINUE
      DIST = SQRT(DIST)
C
      RETURN
      END
C*MODULE MBLDR   *DECK MSGSET
C     ---------------------------------------
      SUBROUTINE MSGSET(MSGDBL,MSGINT,MSGCHR)
C     ---------------------------------------
      MSGDBL = 65536
      MSGINT = 131072
      MSGCHR = 262144
      RETURN
      END
C     ---------------
      SUBROUTINE ABRT
C     ---------------
      STOP 240
      END
C
      SUBROUTINE DDI_BCAST( MSGTAG, TYPE, BUFF, LEN, FROM )
      RETURN
      END
