1
 
                                                  June 24, 1992
 
                             Program MBLDR
 
              "Model Builder" computes the principal axis Cartesian
          coordinates, and the internuclear distance matrix, when
          given the internal coordinates in Z-matrix form.  The
          coordinates in the principal axis system are (almost) in
          the correct form for use as input to GAMESS' $DATA group.
          The principal axes can be permuted, which is sometimes
          necessary to obtain coordinates in the 'master-frame' of
          GAMESS.
 
              MBLDR can read almost any GAUSSIAN style input deck.
          It can also read the Z-matrix in MOPAC style (the top of
          the input file will not be in MOPAC style).  Finally, it
          can read Cartesian coordinates, so that the principal axes
          and distance matrix may be obtained for these.
 
              Much of a MBLDR input deck is suitable to be inserted
          directly into a GAMESS $DATA group.  It is useful to test
          your Z-matrix with a quick running program like MBLDR,
          before using it within GAMESS.
 
              MBLDR will print out an input deck suitable for the
          molecular structure displaying program MOLPLT distributed
          with GAMESS.  You can use this part of the output to 
          visually check the structure you generated with MBLDR.
 
              MBLDR will print out an input deck suitable for use
          with the Macintosh program CHEM3D+.
 
 
 
          More information:
 
              This document is only intended to provide a terse
          description of the various Z-matrix options.  If you are
          unfamiliar with these, consult Tim Clark's book "A
          Handbook of Computational Chemistry" (John Wiley & Sons,
          1985) for a more involved Z-matrix description.
 
1
 
            All input paths begin with the same 5 header cards,
 
          ----------------------------------------------------------
          @MBLDR1    [#... | MOPAC | CART]
                     [AXES=<X>,<Y>,<Z>]  [BOHR]   [NOPRIN]
          ----------------------------------------------------------
          Keyword options are:
          #...  causes a GAUSSIAN style Z-matrix to be read.
                Any information following the 'pound' is ignored.
                The default input path G is followed.
          MOPAC causes a MOPAC style Z-matrix to be read.
                Input path M is followed.
          CART  causes Cartesian coordinates to be read.
                Input path C is followed.
          AXES  causes reordering of the principal axes in the
                manner specified after the keyword.
          BOHR  causes bond distances or Cartesians to be treated
                as atomic units.  The default is Angstroms.
          NOPRIN skips transformation to principal axis frame.

          The keywords AXES, BOHR, and NPRIN apply to any of the
          input paths.  If one of them is chosen for path G, you 
          must not give a 'pound sign' card.
 
          ----------------------------------------------------------
          @MBLDR2    {blank line}
          ----------------------------------------------------------
 
          ----------------------------------------------------------
          @MBLDR3    <title>
          ----------------------------------------------------------
          A single card describing your molecule.
 
          ----------------------------------------------------------
          @MBLDR4    {blank line}
          ----------------------------------------------------------
 
          ----------------------------------------------------------
          @MBLDR5    <charge> <multiplicity>
          ----------------------------------------------------------
          The molecular charge and spin multiplicity should be given
          here, although MBLDR does not do anything with this data.
 
1
 
                    **** PATH G (GAUSSIAN style) ****
 
          ----------------------------------------------------------
          @MBLDR6G   <atom1>
          ----------------------------------------------------------
          Only the name of the first atom is required.
          See @MBLDR9G for a description of this information.
 
          ----------------------------------------------------------
          @MBLDR7G   <atom2> <i1> <bl>
          ----------------------------------------------------------
          Only a name and a bond distance is required for atom 2.
          See @MBLDR9G for a description of this information.

          ----------------------------------------------------------
          @MBLDR8G   <atom3> <i1> <bl> <i2> <alpha>
          ----------------------------------------------------------
          Only a name, distance, and angle are required for atom 3.
          See @MBLDR9G for a description of this information.
 
          ----------------------------------------------------------
          @MBLDR9G   <atom> <i1> <bl> <i2> <alpha> <i3> <beta> <i4>
          ----------------------------------------------------------
          <atom>  is the chemical symbol of this atom.
          <i1>    defines the connectivity of the following bond.
          <bl>    is the bond length "this atom-atom <i1>".
          <i2>    defines the connectivity of the following angle.
          <alpha> is the angle "this atom-atom <i1>-atom <i2>".
          <i3>    defines the connectivity of the following angle.
          <beta>  is either the dihedral angle "this atom-atom <i1>-
                  atom <i2>-atom <i3>", or perhaps a second bond
                  angle "this atom-atom <i1>-atom <i3>".
          <i4>    defines the nature of <beta>.
                  If <beta> is a dihedral angle, <i4>=0 (default).
                  If <beta> is a second bond angle, <i4>=+/-1.
                  (sign specifies one of two possible directions).
 
                o  Repeat this card for atoms 4, 5, ...
                o  The use of ghost atoms is possible, by using X
                   or BQ for the chemical symbol.
                o  In @MBLDR6G-@MBLDR9G, symbolic strings may may
                   be given in place of numeric values for <bl>,
                   <angle>, and <beta>.  The same string may be
                   repeated, which is handy in enforcing
                   symmetry.  If the string is preceeded by a
                   minus sign, the numeric value which will be
                   used is the opposite, of course.  Any mixture
                   of numeric data and symbols may be given.
 
          ----------------------------------------------------------
          @MBLDR10G  {blank line}
          ----------------------------------------------------------
          A blank line terminates the Z-matrix section.
 
1
 
          ----------------------------------------------------------
          @MBLDR11G  <string> <value>
          ----------------------------------------------------------
          <string> is a symbolic string used in the Z-matrix.
          <value>  is the numeric value to substitute for
                   <string> in the Z-matrix.
 
                o  Repeat this card until all symbolic variables
                   in your Z-matrix are defined.
                o  Blank cards encountered while reading @MBLDR11G
                   are simply ignored.  The program continues to
                   read @MBLDR11G until reaching the end of file.
 
 
 
 
                       **** PATH M (MOPAC style) ****
 
          ------------------------------------------------------------
          @MBLDR6M    <atom1>
          ------------------------------------------------------------
          Only the name of the first atom is required.
          See @MBLDR9M for a description of this information.
 
          ------------------------------------------------------------
          @MBLDR7M    <atom2> <bl>
          ------------------------------------------------------------
          Only a name and a bond distance is required for atom 2.
          See @MBLDR9M for a description of this information.
 
          ------------------------------------------------------------
          @MBLDR8M    <atom3> <bl> <j1> <alpha>
          ------------------------------------------------------------
          Only a name, distance, and angle are required for atom 3.
          The third atom is always connected to atom 2 in MOPAC!
          See @MBLDR9M for a description of this information.
 
          ------------------------------------------------------------
          @MBLDR9M    <atom> <bl> <j1> <alpha> <j2> <beta> <j3>
                         <i1> <i2> <i3>
          ------------------------------------------------------------
          <atom>, <bl>, <alpha>, <beta>, <i1>, <i2> and <i3> are as
          described in @MBLDR9G.  <Beta> is always a dihedral angle.
          The <j1>, <j2> and <j3> integers, used in MOPAC to signal
          optimization of parameters, must be supplied but are ignored
          by MBLDR.
 
                 o  Repeat this card for atoms 4, 5, ...
 
          ------------------------------------------------------------
          @MBLDR10M   {blank line}
          ------------------------------------------------------------
          A blank line terminates the Z-matrix section.
 
1
 
 
 
                       **** PATH C (Cartesians) ****
 
          ------------------------------------------------------------
          @MBLDR6C  <atom> <nucZ> <x> <y> <z>
          ------------------------------------------------------------
          <atom>       is the chemical symbol of this atom.
          <nucZ>       is the nuclear charge of this atom.
          <x>,<y>,<z>  are the x, y and z coordinates of this atom.
 
                o  Repeat this card for atoms 1, 2, ...
 

 
                      * * * * * * * * * * * * * *

 
 
          Execution of MBLDR:

              See inside the source code 'mbldr.code' for how
          to compile the program.
 
              The input for MBLDR should be in a file 'xxx.mb',
          Assuming the execution script is on your Unix path,
                  mbldr xxx
          will run the program, placing the output in 'xxx.lis'.
 
          A sample input file (PATH G) is shown below:
          AXES=x,z,y
 
          MBLDR test case...bicyclo H2Si2O2...C2v
 
          0 1
          O
          Si 1 rSiO
          Si 2 rSiSi  1 aSiSiO
          O  3 rSiO   2 aSiSiO    1 wOSiSiO
          H  2 rSiH   1 aHSiSi    4 aHSiSi  1
          H  3 rSiH   1 aHSiSi    4 aHSiSi -1
 
          rSiO   1.6990110
          rSiSi  2.3055047
          rSiH   1.5086463
          aSiSiO  47.27468
          aHSiSi=108.38579
          wOSiSiO=140.2980
 
